# Python Plot MCP

一个专注于 Python 画图的 MCP (Model Context Protocol) 服务器，支持在云端执行 Python 代码并生成 matplotlib 图表。

## 功能特点

- ✅ **Python 沙箱执行**：安全隔离的 Python 代码执行环境
- ✅ **Matplotlib 支持**：内置 matplotlib 和中文字体
- ✅ **Base64 图像返回**：生成的图表直接返回为 data URL
- ✅ **完整 MCP 协议**：符合 MCP 标准
- ✅ **多种安装方式**：支持 uvx、pip、npx

## 安装

### 方式一：uvx（推荐 - 魔搭平台）

```bash
uvx python-plot-mcp
```

### 方式二：pip

```bash
pip install python-plot-mcp
python-plot-mcp
```

### 方式三：npx（Node.js）

```bash
npx python-plot-sandbox-mcp
```

## 使用

### 魔搭平台配置

在魔搭 MCP 广场或支持 MCP 的客户端中配置：

```json
{
  "mcpServers": {
    "python-plot": {
      "command": "uvx",
      "args": ["python-plot-mcp"]
    }
  }
}
```

### 本地开发配置

```json
{
  "mcpServers": {
    "python-plot": {
      "command": "python",
      "args": ["-m", "python_plot_mcp"]
    }
  }
}
```

## 工具：run_python

执行 Python 代码并生成图表。

### 参数

- `code` (string, 必需): Python 代码
- `timeout_s` (integer, 可选): 超时时间（秒），默认 12
- `return_inline_image` (boolean, 可选): 返回 base64 图片，默认 true

### 示例

```python
import matplotlib.pyplot as plt
import numpy as np

x = np.linspace(0, 10, 100)
y = np.sin(x)

plt.figure(figsize=(10, 6))
plt.plot(x, y)
plt.title('正弦波')
plt.xlabel('x')
plt.ylabel('sin(x)')
plt.grid(True)
plt.show()
```

## 依赖

- Python 3.9+
- matplotlib
- numpy
- Pillow

## 许可证

MIT

## 作者

Your Name
