# Example Projects

Complete example projects demonstrating real-world usage patterns.

## Available Projects

### 1. REST API Testing

Complete example of testing a REST API with CRUD operations.

**Features:**

- GET, POST, PUT, DELETE requests
- Environment switching (dev/prod)
- Response validation
- Error handling

**Run:** `cd rest-api-testing && python main.py`

### 2. Microservices Testing

Example of testing multiple microservices with shared state.

**Features:**

- Multi-service integration testing
- Token passing between services
- Service dependency handling
- Shared state management

**Run:** `cd microservices-testing && python main.py`

## Using These Projects

Each project is self-contained and can be:

- Run directly as-is
- Used as a reference for your own projects
- Copied and customized for your needs

## Project Structure

Each project includes:

- Complete Postman collections
- Environment files
- Executable Python scripts
- Documentation
