from pptx.enum.action import PP_ACTION_TYPE
from pptx.oxml.shapes.shared import CT_NonVisualDrawingProps
from pptx.oxml.text import CT_TextCharacterProperties
from pptx.shapes import Subshape
from pptx.shapes.base import BaseShape
from pptx.slide import Slide
from pptx.util import lazyproperty

class ActionSetting(Subshape):
    _element: CT_NonVisualDrawingProps | CT_TextCharacterProperties
    _hover: bool
    def __init__(
        self, xPr: CT_NonVisualDrawingProps | CT_TextCharacterProperties, parent: BaseShape, hover: bool = ...
    ) -> None: ...
    @property
    def action(self) -> PP_ACTION_TYPE: ...
    @lazyproperty
    def hyperlink(self) -> Hyperlink: ...
    @property
    def target_slide(self) -> Slide | None: ...
    @target_slide.setter
    def target_slide(self, slide: Slide | None) -> None: ...

class Hyperlink(Subshape):
    _element: CT_NonVisualDrawingProps | CT_TextCharacterProperties
    _hover: bool
    def __init__(
        self, xPr: CT_NonVisualDrawingProps | CT_TextCharacterProperties, parent: BaseShape, hover: bool = ...
    ) -> None: ...
    @property
    def address(self) -> str | None: ...
    @address.setter
    def address(self, url: str | None) -> None: ...
