from typing import Literal

from pptx.dml.chtfmt import ChartFormat
from pptx.enum.chart import XL_AXIS_CROSSES, XL_CATEGORY_TYPE, XL_TICK_LABEL_POSITION, XL_TICK_MARK
from pptx.oxml.chart.axis import BaseAxisElement
from pptx.oxml.chart.shared import CT_Title
from pptx.shared import ElementProxy
from pptx.text.text import Font, TextFrame
from pptx.util import lazyproperty

class _BaseAxis:
    def __init__(self, xAx: BaseAxisElement) -> None: ...
    @property
    def axis_title(self) -> AxisTitle: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...
    @property
    def has_major_gridlines(self) -> bool: ...
    @has_major_gridlines.setter
    def has_major_gridlines(self, value: bool) -> None: ...
    @property
    def has_minor_gridlines(self) -> bool: ...
    @has_minor_gridlines.setter
    def has_minor_gridlines(self, value: bool) -> None: ...
    @property
    def has_title(self) -> bool: ...
    @has_title.setter
    def has_title(self, value: bool) -> None: ...
    @lazyproperty
    def major_gridlines(self) -> MajorGridlines: ...
    @property
    def major_tick_mark(self) -> XL_TICK_MARK: ...
    @major_tick_mark.setter
    def major_tick_mark(self, value: XL_TICK_MARK) -> None: ...
    @property
    def maximum_scale(self: float | None): ...
    @maximum_scale.setter
    def maximum_scale(self, value: float | None) -> None: ...
    @property
    def minimum_scale(self) -> float | None: ...
    @minimum_scale.setter
    def minimum_scale(self, value: float | None) -> None: ...
    @property
    def minor_tick_mark(self) -> XL_TICK_MARK: ...
    @minor_tick_mark.setter
    def minor_tick_mark(self, value: XL_TICK_MARK) -> None: ...
    @property
    def reverse_order(self): ...
    @reverse_order.setter
    def reverse_order(self, value: bool) -> None: ...
    @lazyproperty
    def tick_labels(self) -> TickLabels: ...
    @property
    def tick_label_position(self) -> XL_TICK_LABEL_POSITION: ...
    @tick_label_position.setter
    def tick_label_position(self, value: XL_TICK_LABEL_POSITION | None) -> None: ...
    @property
    def visible(self) -> bool: ...
    @visible.setter
    def visible(self, value: bool) -> None: ...

class AxisTitle(ElementProxy):
    def __init__(self, title: CT_Title) -> None: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...
    @property
    def has_text_frame(self) -> bool: ...
    @has_text_frame.setter
    def has_text_frame(self, value: bool) -> None: ...
    @property
    def text_frame(self) -> TextFrame: ...

class CategoryAxis(_BaseAxis):
    @property
    def category_type(self) -> Literal[XL_CATEGORY_TYPE.CATEGORY_SCALE]: ...

class DateAxis(_BaseAxis):
    @property
    def category_type(self) -> Literal[XL_CATEGORY_TYPE.TIME_SCALE]: ...

class MajorGridlines(ElementProxy):
    def __init__(self, xAx: BaseAxisElement) -> None: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...

class TickLabels:
    def __init__(self, xAx_elm: BaseAxisElement) -> None: ...
    @lazyproperty
    def font(self) -> Font: ...
    @property
    def number_format(self) -> str: ...
    @number_format.setter
    def number_format(self, value: str) -> None: ...
    @property
    def number_format_is_linked(self) -> bool: ...
    @number_format_is_linked.setter
    def number_format_is_linked(self, value: bool) -> None: ...
    @property
    def offset(self) -> int: ...
    @offset.setter
    def offset(self, value: int) -> None: ...

class ValueAxis(_BaseAxis):
    @property
    def crosses(self) -> XL_AXIS_CROSSES: ...
    @crosses.setter
    def crosses(self, value: XL_AXIS_CROSSES) -> None: ...
    @property
    def crosses_at(self) -> float | None: ...
    @crosses_at.setter
    def crosses_at(self, value: float | None) -> None: ...
    @property
    def major_unit(self) -> float | None: ...
    @major_unit.setter
    def major_unit(self, value: float | None) -> None: ...
    @property
    def minor_unit(self) -> float | None: ...
    @minor_unit.setter
    def minor_unit(self, value: float | None) -> None: ...
