from collections.abc import Generator, Iterable, Sequence
from typing import Self

from pptx.oxml.chart.plot import BaseChartElement
from pptx.oxml.chart.series import CT_Lvl, CT_StrVal_NumVal_Composite

class Categories(Sequence[Category]):
    _xChart: BaseChartElement
    def __init__(self, xChart: BaseChartElement) -> None: ...
    def __getitem__(self, idx) -> Category: ...
    def __iter__(self) -> Generator[Category]: ...
    def __len__(self) -> int: ...
    @property
    def depth(self) -> int: ...
    @property
    def flattened_labels(self) -> Iterable[tuple[str, ...]]: ...
    @property
    def levels(self) -> list[CategoryLevel]: ...

class Category(str):
    _element: CT_StrVal_NumVal_Composite
    _pt: CT_StrVal_NumVal_Composite
    _idx: int | None
    def __new__(cls, pt: CT_StrVal_NumVal_Composite | None, *args) -> Self: ...
    def __init__(self, pt: CT_StrVal_NumVal_Composite | None, idx: int | None = ...) -> None: ...
    @property
    def idx(self) -> int: ...
    @property
    def label(self) -> str: ...

class CategoryLevel(Sequence):
    _lvl: CT_Lvl
    _element: CT_Lvl
    def __init__(self, lvl: CT_Lvl) -> None: ...
    def __getitem__(self, offset: int) -> Category: ...
    def __len__(self) -> int: ...
