from collections.abc import Sequence

from pptx.chart.axis import CategoryAxis, DateAxis, ValueAxis
from pptx.chart.data import _BaseChartData
from pptx.chart.legend import Legend
from pptx.chart.plot import _BasePlot
from pptx.chart.series import SeriesCollection, _BaseCategorySeries, _BaseSeries
from pptx.dml.chtfmt import ChartFormat
from pptx.enum.chart import XL_CHART_TYPE
from pptx.oxml.chart.chart import CT_ChartSpace, CT_PlotArea
from pptx.oxml.chart.shared import CT_Title
from pptx.parts.chart import ChartPart
from pptx.shared import ElementProxy, PartElementProxy
from pptx.text.text import Font, TextFrame
from pptx.util import lazyproperty

class Chart[SeriesType: _BaseSeries, PlotType: _BasePlot](PartElementProxy):
    _chartSpace: CT_ChartSpace
    def __init__(self, chartSpace: CT_ChartSpace, chart_part: ChartPart) -> None: ...
    @property
    def category_axis(self) -> CategoryAxis | DateAxis | ValueAxis: ...
    @property
    def chart_style(self) -> int | None: ...
    @chart_style.setter
    def chart_style(self, value: int | None) -> None: ...
    @property
    def chart_title(self) -> ChartTitle: ...
    @property
    def chart_type(self) -> XL_CHART_TYPE: ...
    @lazyproperty
    def font(self) -> Font: ...
    @property
    def has_legend(self) -> bool: ...
    @has_legend.setter
    def has_legend(self, value: bool) -> None: ...
    @property
    def has_title(self) -> bool: ...
    @has_title.setter
    def has_title(self, value: bool) -> None: ...
    @property
    def legend(self) -> Legend | None: ...
    @lazyproperty
    def plots(self) -> _Plots[PlotType]: ...
    def replace_data(self, chart_data: _BaseChartData) -> None: ...
    @lazyproperty
    def series(self) -> SeriesCollection[SeriesType]: ...
    @property
    def value_axis(self) -> ValueAxis: ...

DefaultChart = Chart[_BaseSeries | _BaseCategorySeries, _BasePlot]
"""Type-checking alias.

This symbol exists only in stubs and is not available at runtime.
Do not import or reference it in production code. Always import this under
`TYPE_CHECKING` guards.
"""

class ChartTitle(ElementProxy):
    _title: CT_Title
    def __init__(self, title: CT_Title) -> None: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...
    @property
    def has_text_frame(self) -> bool: ...
    @has_text_frame.setter
    def has_text_frame(self, value: bool) -> None: ...
    @property
    def text_frame(self) -> TextFrame: ...

class _Plots[PlotType: _BasePlot](Sequence[PlotType]):
    _plotArea: CT_PlotArea
    _chart: Chart
    def __init__(self, plotArea: CT_PlotArea, chart: Chart) -> None: ...
    def __getitem__(self, index: slice | int) -> PlotType: ...
    def __len__(self) -> int: ...
