from collections.abc import Generator, Iterable, Sequence
from typing import Any

class _BaseChartData[SeriesDataType: _BaseSeriesData](Sequence[SeriesDataType]):
    def __init__(self, number_format: str = ...) -> None: ...
    def __getitem__(self, index: int) -> SeriesDataType: ...
    def __len__(self) -> int: ...
    def append(self, series: SeriesDataType) -> None: ...
    def data_point_offset(self, series: SeriesDataType) -> int: ...
    @property
    def number_format(self) -> str: ...
    def series_index(self, series) -> int: ...
    def series_name_ref(self, series) -> str: ...
    def x_values_ref(self, series) -> str: ...
    @property
    def xlsx_blob(self) -> bytes: ...
    def xml_bytes(self, chart_type) -> bytes: ...
    def y_values_ref(self, series) -> str: ...

class _BaseSeriesData[ChartDataType: "_BaseChartData", DataPointType: "_BaseDataPoint"](Sequence[DataPointType]):
    def __init__(self, chart_data: ChartDataType, name: str | None, number_format: str | None) -> None: ...
    def __getitem__(self, index: int) -> DataPointType: ...
    def __len__(self) -> int: ...
    def append(self, data_point: DataPointType) -> None: ...
    @property
    def data_point_offset(self) -> int: ...
    @property
    def index(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def name_ref(self) -> str: ...
    @property
    def number_format(self) -> str: ...
    @property
    def x_values(self) -> list[Any]: ...
    @property
    def x_values_ref(self) -> str: ...
    @property
    def y_values(self) -> list[Any]: ...
    @property
    def y_values_ref(self) -> str: ...

class _BaseDataPoint:
    def __init__(self, series_data: _BaseSeriesData, number_format: str | None) -> None: ...
    @property
    def number_format(self) -> str: ...

class CategoryChartData(_BaseChartData[CategorySeriesData]):
    def add_category(self, label: str | None) -> Category: ...
    def add_series(
        self, name: str, values: Iterable[float] = ..., number_format: str | None = ...
    ) -> CategorySeriesData: ...
    @property
    def categories(self) -> Categories: ...
    @categories.setter
    def categories(self, category_labels: Iterable[str]) -> None: ...
    @property
    def categories_ref(self) -> str: ...
    def values_ref(self, series) -> str: ...

class Categories(Sequence[Category]):
    def __init__(self) -> None: ...
    def __getitem__(self, idx: int) -> Category: ...
    def __len__(self) -> int: ...
    def add_category(self, label: str | None) -> Category: ...
    @property
    def are_dates(self) -> bool: ...
    @property
    def are_numeric(self) -> bool: ...
    @property
    def depth(self) -> int: ...
    def index(self, category) -> int: ...
    @property
    def leaf_count(self) -> int: ...
    @property
    def levels(self) -> Generator[list[tuple[Any, Any]]]: ...
    @property
    def number_format(self) -> str: ...
    @number_format.setter
    def number_format(self, value: str) -> None: ...

class Category:
    def __init__(self, label: str | None, parent: Category) -> None: ...
    def add_sub_category(self, label: str | None) -> Category: ...
    @property
    def depth(self) -> int: ...
    @property
    def idx(self) -> int: ...
    def index(self, sub_category: Category) -> int: ...
    @property
    def leaf_count(self) -> int: ...
    @property
    def label(self) -> int: ...
    def numeric_str_val(self, date_1904: bool = ...) -> str: ...
    @property
    def sub_categories(self) -> list[Category]: ...

class ChartData(CategoryChartData): ...

class CategorySeriesData(_BaseSeriesData[CategoryChartData, CategoryDataPoint]):
    def add_data_point(self, value, number_format: str | None = ...) -> CategoryDataPoint: ...
    @property
    def categories(self) -> Categories: ...
    @property
    def categories_ref(self) -> str: ...
    @property
    def values(self) -> list[Any]: ...
    @property
    def values_ref(self) -> str: ...

class XyChartData[XYSeriesDataType: XySeriesData](_BaseChartData[XYSeriesDataType]):
    def add_series(self, name: str, number_format: str | None = ...) -> XYSeriesDataType: ...

class BubbleChartData(XyChartData[BubbleSeriesData]):
    def add_series(self, name: str, number_format: str | None = ...) -> BubbleSeriesData: ...
    def bubble_sizes_ref(self, series) -> str: ...

class XySeriesData(_BaseSeriesData[XyChartData, XyDataPoint]):
    def add_data_point(self, x, y, number_format=...) -> XyDataPoint: ...

class BubbleSeriesData(XySeriesData[BubbleChartData, BubbleDataPoint]):
    def add_data_point(self, x, y, size, number_format=...) -> BubbleDataPoint: ...
    @property
    def bubble_sizes(self) -> list[Any]: ...
    @property
    def bubble_sizes_ref(self) -> str: ...

class CategoryDataPoint(_BaseDataPoint):
    def __init__(self, series_data: CategorySeriesData, value, number_format: str | None) -> None: ...
    @property
    def value(self) -> Any: ...

class XyDataPoint(_BaseDataPoint):
    def __init__(self, series_data: XySeriesData, x, y, number_format: str | None) -> None: ...
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...

class BubbleDataPoint(XyDataPoint):
    def __init__(self, series_data: BubbleSeriesData, x, y, size, number_format: str | None) -> None: ...
    @property
    def bubble_size(self) -> Any: ...
