from pptx.enum.chart import XL_DATA_LABEL_POSITION
from pptx.oxml.chart.datalabel import CT_DLbls
from pptx.oxml.chart.series import CT_SeriesComposite
from pptx.text.text import Font, TextFrame
from pptx.util import lazyproperty

class DataLabels:
    def __init__(self, dLbls: CT_DLbls) -> None: ...
    @lazyproperty
    def font(self) -> Font: ...
    @property
    def number_format(self) -> str: ...
    @number_format.setter
    def number_format(self, value: str) -> None: ...
    @property
    def number_format_is_linked(self) -> bool: ...
    @number_format_is_linked.setter
    def number_format_is_linked(self, value: bool) -> None: ...
    @property
    def position(self) -> XL_DATA_LABEL_POSITION | None: ...
    @position.setter
    def position(self, value: XL_DATA_LABEL_POSITION | None) -> None: ...
    @property
    def show_category_name(self) -> bool: ...
    @show_category_name.setter
    def show_category_name(self, value: bool) -> None: ...
    @property
    def show_legend_key(self) -> bool: ...
    @show_legend_key.setter
    def show_legend_key(self, value: bool) -> None: ...
    @property
    def show_percentage(self) -> bool: ...
    @show_percentage.setter
    def show_percentage(self, value: bool) -> None: ...
    @property
    def show_series_name(self) -> bool: ...
    @show_series_name.setter
    def show_series_name(self, value: bool) -> None: ...
    @property
    def show_value(self) -> bool: ...
    @show_value.setter
    def show_value(self, value: bool) -> None: ...

class DataLabel:
    def __init__(self, ser: CT_SeriesComposite, idx: int) -> None: ...
    @lazyproperty
    def font(self) -> Font: ...
    @property
    def has_text_frame(self) -> bool: ...
    @has_text_frame.setter
    def has_text_frame(self, value: bool) -> None: ...
    @property
    def position(self) -> XL_DATA_LABEL_POSITION | None: ...
    @position.setter
    def position(self, value: XL_DATA_LABEL_POSITION | None) -> None: ...
    @property
    def text_frame(self) -> TextFrame: ...
