from collections.abc import Sequence

from pptx.chart.datalabel import DataLabel
from pptx.chart.marker import Marker
from pptx.dml.chtfmt import ChartFormat
from pptx.oxml.chart.series import CT_SeriesComposite
from pptx.util import lazyproperty

class _BasePoints(Sequence[Point]):
    def __init__(self, ser: CT_SeriesComposite) -> None: ...
    def __getitem__(self, idx: int) -> Point: ...

class BubblePoints(_BasePoints):
    def __len__(self) -> int: ...

class CategoryPoints(_BasePoints):
    def __len__(self) -> int: ...

class Point:
    def __init__(self, ser: CT_SeriesComposite, idx: int) -> None: ...
    @lazyproperty
    def data_label(self) -> DataLabel: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...
    @lazyproperty
    def marker(self) -> Marker: ...

class XyPoints(_BasePoints):
    def __len__(self) -> int: ...
