from collections.abc import Generator, Sequence

from pptx.chart.datalabel import DataLabels
from pptx.chart.marker import Marker
from pptx.chart.point import BubblePoints, CategoryPoints, XyPoints
from pptx.dml.chtfmt import ChartFormat
from pptx.oxml.chart.chart import CT_PlotArea
from pptx.oxml.chart.plot import BaseChartElement
from pptx.oxml.chart.series import CT_SeriesComposite
from pptx.util import lazyproperty

class _BaseSeries:
    def __init__(self, ser: CT_SeriesComposite) -> None: ...
    @lazyproperty
    def format(self) -> ChartFormat: ...
    @property
    def index(self) -> int: ...
    @property
    def name(self) -> str: ...

class _BaseCategorySeries(_BaseSeries):
    @lazyproperty
    def data_labels(self) -> DataLabels: ...
    @lazyproperty
    def points(self) -> CategoryPoints: ...
    @property
    def values(self) -> tuple[float, ...]: ...

class _MarkerMixin:
    @lazyproperty
    def marker(self) -> Marker: ...

class AreaSeries(_BaseCategorySeries): ...

class BarSeries(_BaseCategorySeries):
    @property
    def invert_if_negative(self) -> bool: ...
    @invert_if_negative.setter
    def invert_if_negative(self, value: bool) -> None: ...

class LineSeries(_BaseCategorySeries, _MarkerMixin):
    @property
    def smooth(self) -> bool: ...
    @smooth.setter
    def smooth(self, value: bool) -> None: ...

class PieSeries(_BaseCategorySeries): ...
class RadarSeries(_BaseCategorySeries, _MarkerMixin): ...

class XySeries(_BaseSeries, _MarkerMixin):
    def iter_values(self) -> Generator[float]: ...
    @lazyproperty
    def points(self) -> XyPoints: ...
    @property
    def values(self) -> tuple[float, ...]: ...

class BubbleSeries(XySeries):
    @lazyproperty
    def points(self) -> BubblePoints: ...

class SeriesCollection[SeriesType: "_BaseSeries"](Sequence[SeriesType]):
    def __init__(self, parent_elm: CT_PlotArea | BaseChartElement) -> None: ...
    def __getitem__(self, index: int) -> SeriesType: ...
    def __len__(self) -> int: ...
