from pptx.chart.data import BubbleChartData, CategoryChartData, XyChartData, _BaseChartData

class _BaseWorkbookWriter[ChartDataType: _BaseChartData]:
    def __init__(self, chart_data: ChartDataType) -> None: ...
    @property
    def xlsx_blob(self) -> bytes: ...

class CategoryWorkbookWriter(_BaseWorkbookWriter[CategoryChartData]):
    @property
    def categories_ref(self) -> str: ...
    def series_name_ref(self, series) -> str: ...
    def values_ref(self, series) -> str: ...

class XyWorkbookWriter(_BaseWorkbookWriter[XyChartData]):
    def series_name_ref(self, series) -> str: ...
    def series_table_row_offset(self, series) -> int: ...
    def x_values_ref(self, series) -> str: ...
    def y_values_ref(self, series) -> str: ...

class BubbleWorkbookWriter(XyWorkbookWriter[BubbleChartData]):
    def bubble_sizes_ref(self, series) -> str: ...
