from collections.abc import Iterable

from pptx.chart.data import _BaseChartData
from pptx.chart.series import _BaseSeries
from pptx.enum.chart import XL_CHART_TYPE
from pptx.oxml.chart.chart import CT_ChartSpace
from pptx.oxml.chart.series import CT_AxDataSource, CT_NumDataSource
from pptx.oxml.chart.shared import CT_Tx

def ChartXmlWriter(chart_type: XL_CHART_TYPE, chart_data: _BaseChartData): ...
def SeriesXmlRewriterFactory(chart_type: XL_CHART_TYPE, chart_data: _BaseChartData): ...

class _BaseChartXmlWriter:
    def __init__(self, chart_type: XL_CHART_TYPE, series_seq: Iterable[_BaseSeries]) -> None: ...
    @property
    def xml(self) -> str: ...

class _BaseSeriesXmlWriter:
    def __init__(self, series: _BaseSeries, date_1904: bool = ...) -> None: ...
    @property
    def name(self) -> str: ...
    def numRef_xml(self, wksht_ref, number_format, values) -> str: ...
    def pt_xml(self, values) -> str: ...
    @property
    def tx(self) -> CT_Tx: ...
    @property
    def tx_xml(self) -> str: ...

class _BaseSeriesXmlRewriter:
    def __init__(self, chart_data: _BaseChartData) -> None: ...
    def replace_series_data(self, chartSpace: CT_ChartSpace) -> None: ...

class _AreaChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _BarChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _DoughnutChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _LineChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _PieChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _RadarChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _XyChartXmlWriter(_BaseChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _BubbleChartXmlWriter(_XyChartXmlWriter):
    @property
    def xml(self) -> str: ...

class _CategorySeriesXmlWriter(_BaseSeriesXmlWriter):
    @property
    def cat(self) -> CT_AxDataSource: ...
    @property
    def cat_xml(self) -> str: ...
    @property
    def val(self) -> CT_NumDataSource: ...
    @property
    def val_xml(self) -> str: ...

class _XySeriesXmlWriter(_BaseSeriesXmlWriter):
    @property
    def xVal(self) -> CT_NumDataSource: ...
    @property
    def xVal_xml(self) -> str: ...
    @property
    def yVal(self) -> CT_NumDataSource: ...
    @property
    def yVal_xml(self) -> str: ...

class _BubbleSeriesXmlWriter(_XySeriesXmlWriter):
    @property
    def bubbleSize(self) -> CT_NumDataSource: ...
    @property
    def bubbleSize_xml(self) -> str: ...

class _BubbleSeriesXmlRewriter(_BaseSeriesXmlRewriter): ...
class _CategorySeriesXmlRewriter(_BaseSeriesXmlRewriter): ...
class _XySeriesXmlRewriter(_BaseSeriesXmlRewriter): ...
