from typing import Literal, Self

from pptx.enum.dml import MSO_COLOR_TYPE, MSO_THEME_COLOR, MSO_THEME_COLOR_INDEX
from pptx.oxml.dml.color import (
    CT_Color,
    CT_HslColor,
    CT_PresetColor,
    CT_SchemeColor,
    CT_ScRgbColor,
    CT_SRgbColor,
    CT_SystemColor,
)

type ColorElement = CT_HslColor | CT_PresetColor | CT_SchemeColor | CT_ScRgbColor | CT_ScRgbColor | CT_SystemColor

class ColorFormat:
    _xFill: CT_Color
    _color: _Color
    def __init__(self, eg_colorChoice_parent: CT_Color, color: _Color) -> None: ...
    @property
    def brightness(self) -> float: ...
    @brightness.setter
    def brightness(self, value: float) -> None: ...
    @classmethod
    def from_colorchoice_parent(cls, eg_colorChoice_parent: CT_Color) -> Self: ...
    @property
    def rgb(self) -> RGBColor: ...
    @rgb.setter
    def rgb(self, rgb: RGBColor) -> None: ...
    @property
    def theme_color(self) -> MSO_THEME_COLOR_INDEX: ...
    @theme_color.setter
    def theme_color(self, mso_theme_color_idx: MSO_THEME_COLOR_INDEX) -> None: ...
    @property
    def type(self) -> MSO_COLOR_TYPE: ...

class _Color:
    _xclr: ColorElement
    def __new__(cls, xClr: ColorElement | None) -> Self: ...
    def __init__(self, xClr: ColorElement | None) -> None: ...
    @property
    def brightness(self) -> float: ...
    @brightness.setter
    def brightness(self, value: float) -> None: ...
    @property
    def color_type(self) -> MSO_COLOR_TYPE: ...
    @property
    def rgb(self) -> RGBColor: ...
    @property
    def theme_color(self) -> Literal[MSO_THEME_COLOR_INDEX.NOT_THEME_COLOR]: ...
    def _shade(self, value: float): ...
    def _tint(self, value: float): ...

class _HslColor(_Color):
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.HSL]: ...

class _NoneColor(_Color):
    @property
    def color_type(self) -> None: ...
    @property
    def theme_color(self): ...

class _PrstColor(_Color):
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.PRESET]: ...

class _SchemeColor(_Color):
    def __init__(self, schemeClr) -> None: ...
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.SCHEME]: ...
    @property
    def theme_color(self) -> MSO_THEME_COLOR | None: ...
    @theme_color.setter
    def theme_color(self, mso_theme_color_idx: MSO_THEME_COLOR) -> None: ...

class _ScRgbColor(_Color):
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.SCRGB]: ...

class _SRgbColor(_Color):
    def __init__(self, srgbClr: CT_SRgbColor) -> None: ...
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.RGB]: ...
    @property
    def rgb(self) -> RGBColor: ...
    @rgb.setter
    def rgb(self, rgb) -> None: ...

class _SysColor(_Color):
    @property
    def color_type(self) -> Literal[MSO_COLOR_TYPE.SYSTEM]: ...

class RGBColor(tuple[int, int, int]):
    def __new__(cls, r: int, g: int, b: int) -> Self: ...
    def __str__(self) -> str: ...
    @classmethod
    def from_string(cls, rgb_hex_str: str) -> Self: ...
