from collections.abc import Sequence
from typing import Literal, Self

from pptx.dml.color import ColorFormat
from pptx.enum.dml import MSO_FILL_TYPE, MSO_PATTERN_TYPE
from pptx.oxml.dml.fill import (
    CT_BlipFillProperties,
    CT_GradientFillProperties,
    CT_GradientStop,
    CT_GroupFillProperties,
    CT_NoFillProperties,
    CT_PatternFillProperties,
    CT_SolidColorFillProperties,
)
from pptx.oxml.xmlchemy import BaseOxmlElement
from pptx.shared import ElementProxy
from pptx.util import lazyproperty

class FillFormat:
    _xPr: BaseOxmlElement
    _fill: _Fill
    def __init__(self, eg_fill_properties_parent: BaseOxmlElement, fill_obj: _Fill) -> None: ...
    @classmethod
    def from_fill_parent(cls, eg_fillProperties_parent: BaseOxmlElement) -> FillFormat: ...
    @property
    def back_color(self) -> ColorFormat: ...
    def background(self) -> None: ...
    @property
    def fore_color(self) -> ColorFormat: ...
    def gradient(self) -> None: ...
    @property
    def gradient_angle(self) -> float | None: ...
    @gradient_angle.setter
    def gradient_angle(self, value) -> None: ...
    @property
    def gradient_stops(self) -> _GradientStops: ...
    @property
    def pattern(self) -> MSO_PATTERN_TYPE | None: ...
    @pattern.setter
    def pattern(self, pattern_type: MSO_PATTERN_TYPE | None) -> None: ...
    def patterned(self) -> None: ...
    def solid(self) -> None: ...
    @property
    def type(self) -> MSO_FILL_TYPE: ...

class _Fill[FillElementType: BaseOxmlElement]:
    def __new__(cls, xFill: FillElementType | BaseOxmlElement) -> Self: ...
    @property
    def back_color(self) -> ColorFormat: ...
    @property
    def fore_color(self) -> ColorFormat: ...
    @property
    def pattern(self) -> MSO_PATTERN_TYPE | None: ...
    @property
    def type(self) -> MSO_FILL_TYPE | None: ...

class _BlipFill(_Fill[CT_BlipFillProperties]):
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.PICTURE]: ...

class _GradFill(_Fill[CT_GradientFillProperties]):
    def __init__(self, gradFill: CT_GradientFillProperties) -> None: ...
    @property
    def gradient_angle(self) -> float | None: ...
    @gradient_angle.setter
    def gradient_angle(self, value: float) -> None: ...
    @lazyproperty
    def gradient_stops(self) -> _GradientStops: ...
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.GRADIENT]: ...

class _GrpFill(_Fill[CT_GroupFillProperties]):
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.GROUP]: ...

class _NoFill(_Fill[CT_NoFillProperties]):
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.BACKGROUND]: ...

class _NoneFill(_Fill[BaseOxmlElement]):
    @property
    def type(self) -> None: ...

class _PattFill(_Fill[CT_PatternFillProperties]):
    def __init__(self, pattFill: CT_PatternFillProperties) -> None: ...
    @lazyproperty
    def back_color(self) -> ColorFormat: ...
    @lazyproperty
    def fore_color(self) -> ColorFormat: ...
    @property
    def pattern(self) -> MSO_PATTERN_TYPE | None: ...
    @pattern.setter
    def pattern(self, pattern_type: MSO_PATTERN_TYPE | None) -> None: ...
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.PATTERNED]: ...

class _SolidFill(_Fill[CT_SolidColorFillProperties]):
    def __init__(self, solidFill: CT_SolidColorFillProperties) -> None: ...
    @lazyproperty
    def fore_color(self) -> ColorFormat: ...
    @property
    def type(self) -> Literal[MSO_FILL_TYPE.SOLID]: ...

class _GradientStops(Sequence[_GradientStop]):
    def __init__(self, gsLst: list[CT_GradientStop]) -> None: ...
    def __getitem__(self, idx: int) -> _GradientStop: ...
    def __len__(self) -> int: ...

class _GradientStop(ElementProxy):
    def __init__(self, gs: CT_GradientStop) -> None: ...
    @lazyproperty
    def color(self) -> ColorFormat: ...
    @property
    def position(self) -> float: ...
    @position.setter
    def position(self, value: float) -> None: ...
