from pptx.dml.color import ColorFormat
from pptx.dml.fill import FillFormat
from pptx.enum.dml import MSO_LINE_DASH_STYLE
from pptx.oxml.shapes.shared import CT_LineProperties, CT_ShapeProperties
from pptx.util import Length, lazyproperty

class LineFormat:
    def __init__(self, parent: CT_ShapeProperties) -> None: ...
    @lazyproperty
    def color(self) -> ColorFormat: ...
    @property
    def dash_style(self) -> MSO_LINE_DASH_STYLE | None: ...
    @dash_style.setter
    def dash_style(self, dash_style: MSO_LINE_DASH_STYLE | None) -> None: ...
    @lazyproperty
    def fill(self) -> FillFormat: ...
    @property
    def width(self) -> Length: ...
    @width.setter
    def width(self, emu: Length) -> None: ...
    @property
    def _ln(self) -> CT_LineProperties: ...
