import enum
from typing import Any, Self

class BaseEnum(int, enum.Enum):
    def __new__(cls, ms_api_value: int, docstr: str) -> Self: ...
    def __str__(self) -> str: ...

class BaseXmlEnum[T: BaseXmlEnum](int, enum.Enum):
    xml_value: str | None
    def __new__(cls, ms_api_value: int, xml_value: str | None, docstr: str) -> Self: ...
    def __str__(self) -> str: ...
    @classmethod
    def from_xml(cls, xml_value: str) -> Self: ...
    @classmethod
    def to_xml(cls: type[T], value: int | T) -> str: ...
    @classmethod
    def validate(cls: type[T], value: T) -> None: ...

class DocsPageFormatter:
    def __init__(self, clsname: str, clsdict: dict[str, Any]) -> None: ...
    @property
    def page_str(self) -> str: ...
