import enum
from typing import Literal, Self

from pptx.enum.base import BaseEnum, BaseXmlEnum

class MSO_AUTO_SHAPE_TYPE(BaseXmlEnum):
    ACTION_BUTTON_BACK_OR_PREVIOUS = ...
    ACTION_BUTTON_BEGINNING = ...
    ACTION_BUTTON_CUSTOM = ...
    ACTION_BUTTON_DOCUMENT = ...
    ACTION_BUTTON_END = ...
    ACTION_BUTTON_FORWARD_OR_NEXT = ...
    ACTION_BUTTON_HELP = ...
    ACTION_BUTTON_HOME = ...
    ACTION_BUTTON_INFORMATION = ...
    ACTION_BUTTON_MOVIE = ...
    ACTION_BUTTON_RETURN = ...
    ACTION_BUTTON_SOUND = ...
    ARC = ...
    BALLOON = ...
    BENT_ARROW = ...
    BENT_UP_ARROW = ...
    BEVEL = ...
    BLOCK_ARC = ...
    CAN = ...
    CHART_PLUS = ...
    CHART_STAR = ...
    CHART_X = ...
    CHEVRON = ...
    CHORD = ...
    CIRCULAR_ARROW = ...
    CLOUD = ...
    CLOUD_CALLOUT = ...
    CORNER = ...
    CORNER_TABS = ...
    CROSS = ...
    CUBE = ...
    CURVED_DOWN_ARROW = ...
    CURVED_DOWN_RIBBON = ...
    CURVED_LEFT_ARROW = ...
    CURVED_RIGHT_ARROW = ...
    CURVED_UP_ARROW = ...
    CURVED_UP_RIBBON = ...
    DECAGON = ...
    DIAGONAL_STRIPE = ...
    DIAMOND = ...
    DODECAGON = ...
    DONUT = ...
    DOUBLE_BRACE = ...
    DOUBLE_BRACKET = ...
    DOUBLE_WAVE = ...
    DOWN_ARROW = ...
    DOWN_ARROW_CALLOUT = ...
    DOWN_RIBBON = ...
    EXPLOSION1 = ...
    EXPLOSION2 = ...
    FLOWCHART_ALTERNATE_PROCESS = ...
    FLOWCHART_CARD = ...
    FLOWCHART_COLLATE = ...
    FLOWCHART_CONNECTOR = ...
    FLOWCHART_DATA = ...
    FLOWCHART_DECISION = ...
    FLOWCHART_DELAY = ...
    FLOWCHART_DIRECT_ACCESS_STORAGE = ...
    FLOWCHART_DISPLAY = ...
    FLOWCHART_DOCUMENT = ...
    FLOWCHART_EXTRACT = ...
    FLOWCHART_INTERNAL_STORAGE = ...
    FLOWCHART_MAGNETIC_DISK = ...
    FLOWCHART_MANUAL_INPUT = ...
    FLOWCHART_MANUAL_OPERATION = ...
    FLOWCHART_MERGE = ...
    FLOWCHART_MULTIDOCUMENT = ...
    FLOWCHART_OFFLINE_STORAGE = ...
    FLOWCHART_OFFPAGE_CONNECTOR = ...
    FLOWCHART_OR = ...
    FLOWCHART_PREDEFINED_PROCESS = ...
    FLOWCHART_PREPARATION = ...
    FLOWCHART_PROCESS = ...
    FLOWCHART_PUNCHED_TAPE = ...
    FLOWCHART_SEQUENTIAL_ACCESS_STORAGE = ...
    FLOWCHART_SORT = ...
    FLOWCHART_STORED_DATA = ...
    FLOWCHART_SUMMING_JUNCTION = ...
    FLOWCHART_TERMINATOR = ...
    FOLDED_CORNER = ...
    FRAME = ...
    FUNNEL = ...
    GEAR_6 = ...
    GEAR_9 = ...
    HALF_FRAME = ...
    HEART = ...
    HEPTAGON = ...
    HEXAGON = ...
    HORIZONTAL_SCROLL = ...
    ISOSCELES_TRIANGLE = ...
    LEFT_ARROW = ...
    LEFT_ARROW_CALLOUT = ...
    LEFT_BRACE = ...
    LEFT_BRACKET = ...
    LEFT_CIRCULAR_ARROW = ...
    LEFT_RIGHT_ARROW = ...
    LEFT_RIGHT_ARROW_CALLOUT = ...
    LEFT_RIGHT_CIRCULAR_ARROW = ...
    LEFT_RIGHT_RIBBON = ...
    LEFT_RIGHT_UP_ARROW = ...
    LEFT_UP_ARROW = ...
    LIGHTNING_BOLT = ...
    LINE_CALLOUT_1 = ...
    LINE_CALLOUT_1_ACCENT_BAR = ...
    LINE_CALLOUT_1_BORDER_AND_ACCENT_BAR = ...
    LINE_CALLOUT_1_NO_BORDER = ...
    LINE_CALLOUT_2 = ...
    LINE_CALLOUT_2_ACCENT_BAR = ...
    LINE_CALLOUT_2_BORDER_AND_ACCENT_BAR = ...
    LINE_CALLOUT_2_NO_BORDER = ...
    LINE_CALLOUT_3 = ...
    LINE_CALLOUT_3_ACCENT_BAR = ...
    LINE_CALLOUT_3_BORDER_AND_ACCENT_BAR = ...
    LINE_CALLOUT_3_NO_BORDER = ...
    LINE_CALLOUT_4 = ...
    LINE_CALLOUT_4_ACCENT_BAR = ...
    LINE_CALLOUT_4_BORDER_AND_ACCENT_BAR = ...
    LINE_CALLOUT_4_NO_BORDER = ...
    LINE_INVERSE = ...
    MATH_DIVIDE = ...
    MATH_EQUAL = ...
    MATH_MINUS = ...
    MATH_MULTIPLY = ...
    MATH_NOT_EQUAL = ...
    MATH_PLUS = ...
    MOON = ...
    NON_ISOSCELES_TRAPEZOID = ...
    NOTCHED_RIGHT_ARROW = ...
    NO_SYMBOL = ...
    OCTAGON = ...
    OVAL = ...
    OVAL_CALLOUT = ...
    PARALLELOGRAM = ...
    PENTAGON = ...
    PIE = ...
    PIE_WEDGE = ...
    PLAQUE = ...
    PLAQUE_TABS = ...
    QUAD_ARROW = ...
    QUAD_ARROW_CALLOUT = ...
    RECTANGLE = ...
    RECTANGULAR_CALLOUT = ...
    REGULAR_PENTAGON = ...
    RIGHT_ARROW = ...
    RIGHT_ARROW_CALLOUT = ...
    RIGHT_BRACE = ...
    RIGHT_BRACKET = ...
    RIGHT_TRIANGLE = ...
    ROUNDED_RECTANGLE = ...
    ROUNDED_RECTANGULAR_CALLOUT = ...
    ROUND_1_RECTANGLE = ...
    ROUND_2_DIAG_RECTANGLE = ...
    ROUND_2_SAME_RECTANGLE = ...
    SMILEY_FACE = ...
    SNIP_1_RECTANGLE = ...
    SNIP_2_DIAG_RECTANGLE = ...
    SNIP_2_SAME_RECTANGLE = ...
    SNIP_ROUND_RECTANGLE = ...
    SQUARE_TABS = ...
    STAR_10_POINT = ...
    STAR_12_POINT = ...
    STAR_16_POINT = ...
    STAR_24_POINT = ...
    STAR_32_POINT = ...
    STAR_4_POINT = ...
    STAR_5_POINT = ...
    STAR_6_POINT = ...
    STAR_7_POINT = ...
    STAR_8_POINT = ...
    STRIPED_RIGHT_ARROW = ...
    SUN = ...
    SWOOSH_ARROW = ...
    TEAR = ...
    TRAPEZOID = ...
    UP_ARROW = ...
    UP_ARROW_CALLOUT = ...
    UP_DOWN_ARROW = ...
    UP_DOWN_ARROW_CALLOUT = ...
    UP_RIBBON = ...
    U_TURN_ARROW = ...
    VERTICAL_SCROLL = ...
    WAVE = ...

MSO_SHAPE = MSO_AUTO_SHAPE_TYPE

class MSO_CONNECTOR_TYPE(BaseXmlEnum):
    CURVE = ...
    ELBOW = ...
    STRAIGHT = ...
    MIXED = ...

MSO_CONNECTOR = MSO_CONNECTOR_TYPE

class MSO_SHAPE_TYPE(BaseEnum):
    AUTO_SHAPE = ...
    CALLOUT = ...
    CANVAS = ...
    CHART = ...
    COMMENT = ...
    DIAGRAM = ...
    EMBEDDED_OLE_OBJECT = ...
    FORM_CONTROL = ...
    FREEFORM = ...
    GROUP = ...
    IGX_GRAPHIC = ...
    INK = ...
    INK_COMMENT = ...
    LINE = ...
    LINKED_OLE_OBJECT = ...
    LINKED_PICTURE = ...
    MEDIA = ...
    OLE_CONTROL_OBJECT = ...
    PICTURE = ...
    PLACEHOLDER = ...
    SCRIPT_ANCHOR = ...
    TABLE = ...
    TEXT_BOX = ...
    TEXT_EFFECT = ...
    WEB_VIDEO = ...
    MIXED = ...

MSO = MSO_SHAPE_TYPE

class PP_MEDIA_TYPE(BaseEnum):
    MOVIE = ...
    OTHER = ...
    SOUND = ...
    MIXED = ...

class PP_PLACEHOLDER_TYPE(BaseXmlEnum):
    BITMAP = ...
    BODY = ...
    CENTER_TITLE = ...
    CHART = ...
    DATE = ...
    FOOTER = ...
    HEADER = ...
    MEDIA_CLIP = ...
    OBJECT = ...
    ORG_CHART = ...
    PICTURE = ...
    SLIDE_IMAGE = ...
    SLIDE_NUMBER = ...
    SUBTITLE = ...
    TABLE = ...
    TITLE = ...
    VERTICAL_BODY = ...
    VERTICAL_OBJECT = ...
    VERTICAL_TITLE = ...
    MIXED = ...

PP_PLACEHOLDER = PP_PLACEHOLDER_TYPE

class PROG_ID(enum.Enum):
    _progId: str
    _icon_filename: str
    _width: int
    _height: int
    def __new__(cls, value: str, progId: str, icon_filename: str, width: int, height: int) -> Self: ...
    @property
    def height(self) -> int: ...
    @property
    def icon_filename(self) -> str: ...
    @property
    def progId(self) -> str: ...
    @property
    def width(self) -> int: ...

    DOCX: Literal["DOCX"] = ...
    PPTX: Literal["PPTX"] = ...
    XLSX: Literal["XLSX"] = ...
