from typing import IO, Self

from pptx.util import lazyproperty

class Video:
    _blob: bytes
    _mime_type: str | None
    _filename: str | None

    def __init__(self, blob: bytes, mime_type: str | None, filename: str | None) -> None: ...
    @classmethod
    def from_blob(cls, blob: bytes, mime_type: str | None, filename: str | None = ...) -> Self: ...
    @classmethod
    def from_path_or_file_like(cls, movie_file: str | IO[bytes], mime_type: str | None) -> Self: ...
    @property
    def blob(self) -> bytes: ...
    @property
    def content_type(self) -> str | None: ...
    @property
    def ext(self) -> str: ...
    @property
    def filename(self) -> str: ...
    @lazyproperty
    def sha1(self) -> str: ...

SPEAKER_IMAGE_BYTES: bytes = ...
