from collections.abc import Iterator, Mapping
from typing import IO, Self

from pptx.opc.oxml import CT_Relationship, CT_Relationships
from pptx.opc.packuri import PackURI
from pptx.oxml.xmlchemy import BaseOxmlElement
from pptx.package import Package
from pptx.parts.presentation import PresentationPart
from pptx.util import lazyproperty

class _RelatableMixin:
    def part_related_by(self, reltype: str) -> Part: ...
    def relate_to(self, target: Part | str, reltype: str, is_external: bool = ...) -> str: ...
    def related_part(self, rId: str) -> Part: ...
    def target_ref(self, rId: str) -> str: ...

class OpcPackage(_RelatableMixin):
    def __init__(self, pkg_file: str | IO[bytes]) -> None: ...
    @classmethod
    def open(cls, pkg_file: str | IO[bytes]) -> Self: ...
    def drop_rel(self, rId: str) -> None: ...
    def iter_parts(self) -> Iterator[Part]: ...
    def iter_rels(self) -> Iterator[_Relationship]: ...
    @property
    def main_document_part(self) -> PresentationPart: ...
    def next_partname(self, tmpl: str) -> PackURI: ...
    def save(self, pkg_file: str | IO[bytes]) -> None: ...

class _PackageLoader:
    def __init__(self, pkg_file: str | IO[bytes], package: Package) -> None: ...
    @classmethod
    def load(cls, pkg_file: str | IO[bytes], package: Package) -> tuple[CT_Relationships, dict[PackURI, Part]]: ...

class Part(_RelatableMixin):
    def __init__(self, partname: PackURI, content_type: str, package: Package, blob: bytes | None = ...) -> None: ...
    @classmethod
    def load(cls, partname: PackURI, content_type: str, package: Package, blob: bytes) -> Self: ...
    @property
    def blob(self) -> bytes: ...
    @blob.setter
    def blob(self, blob: bytes) -> None: ...
    @lazyproperty
    def content_type(self) -> str: ...
    def load_rels_from_xml(self, xml_rels: CT_Relationships, parts: dict[PackURI, Part]) -> None: ...
    @lazyproperty
    def package(self) -> Package: ...
    @property
    def partname(self) -> PackURI: ...
    @partname.setter
    def partname(self, partname: PackURI) -> None: ...
    @lazyproperty
    def rels(self) -> _Relationships: ...

class XmlPart(Part):
    def __init__(self, partname: PackURI, content_type: str, package: Package, element: BaseOxmlElement) -> None: ...
    @classmethod
    def load(cls, partname: PackURI, content_type: str, package: Package, blob: bytes) -> Self: ...
    @property
    def blob(self) -> bytes: ...
    def drop_rel(self, rId: str) -> None: ...
    @property
    def part(self) -> Self: ...

class PartFactory:
    part_type_for: dict[str, type[Part]] = ...
    def __new__(cls, partname: PackURI, content_type: str, package: Package, blob: bytes) -> Part: ...

class _ContentTypeMap:
    def __init__(self, overrides: dict[str, str], defaults: dict[str, str]) -> None: ...
    def __getitem__(self, partname: PackURI) -> str: ...
    @classmethod
    def from_xml(cls, content_types_xml: bytes) -> _ContentTypeMap: ...

class _Relationships(Mapping[str, "_Relationship"]):
    def __init__(self, base_uri: str) -> None: ...
    def __contains__(self, rId: object) -> bool: ...
    def __getitem__(self, rId: str) -> _Relationship: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def get_or_add(self, reltype: str, target_part: Part) -> str: ...
    def get_or_add_ext_rel(self, reltype: str, target_ref: str) -> str: ...
    def load_from_xml(self, base_uri: str, xml_rels: CT_Relationships, parts: dict[PackURI, Part]) -> None: ...
    def part_with_reltype(self, reltype: str) -> Part: ...
    def pop(self, rId: str) -> _Relationship: ...
    @property
    def xml(self) -> bytes: ...

class _Relationship:
    def __init__(self, base_uri: str, rId: str, reltype: str, target_mode: str, target: Part | str) -> None: ...
    @classmethod
    def from_xml(cls, base_uri: str, rel: CT_Relationship, parts: dict[PackURI, Part]) -> _Relationship: ...
    @lazyproperty
    def is_external(self) -> bool: ...
    @lazyproperty
    def reltype(self) -> str: ...
    @lazyproperty
    def rId(self) -> str: ...
    @lazyproperty
    def target_part(self) -> Part: ...
    @lazyproperty
    def target_partname(self) -> PackURI: ...
    @lazyproperty
    def target_ref(self) -> str: ...
