from collections.abc import Container, Sequence
from typing import IO, Any

from pptx.opc.oxml import CT_Types
from pptx.opc.package import Part, _Relationships
from pptx.opc.packuri import PackURI

class PackageReader(Container[bytes]):
    def __init__(self, pkg_file: str | IO[bytes]) -> None: ...
    def __contains__(self, pack_uri: object) -> bool: ...
    def __getitem__(self, pack_uri: PackURI) -> bytes: ...
    def rels_xml_for(self, partname: PackURI) -> bytes | None: ...

class PackageWriter:
    def __init__(self, pkg_file: str | IO[bytes], pkg_rels: _Relationships, parts: Sequence[Part]) -> None: ...
    @classmethod
    def write(cls, pkg_file: str | IO[bytes], pkg_rels: _Relationships, parts: Sequence[Part]) -> None: ...

class _PhysPkgReader(Container[PackURI]):
    def __contains__(self, item: object) -> bool: ...
    def __getitem__(self, pack_uri: PackURI) -> bytes: ...
    @classmethod
    def factory(cls, pkg_file: str | IO[bytes]) -> _PhysPkgReader: ...

class _DirPkgReader(_PhysPkgReader):
    def __init__(self, path: str) -> None: ...
    def __contains__(self, pack_uri: object) -> bool: ...
    def __getitem__(self, pack_uri: PackURI) -> bytes: ...

class _ZipPkgReader(_PhysPkgReader):
    def __init__(self, pkg_file: str | IO[bytes]) -> None: ...
    def __contains__(self, pack_uri: object) -> bool: ...
    def __getitem__(self, pack_uri: PackURI) -> bytes: ...

class _PhysPkgWriter:
    @classmethod
    def factory(cls, pkg_file: str | IO[bytes]) -> _ZipPkgWriter: ...
    def write(self, pack_uri: PackURI, blob: bytes) -> None: ...

class _ZipPkgWriter(_PhysPkgWriter):
    def __init__(self, pkg_file: str | IO[bytes]) -> None: ...
    def __enter__(self) -> _ZipPkgWriter: ...
    def __exit__(self, *exc: list[Any]) -> None: ...
    def write(self, pack_uri: PackURI, blob: bytes) -> None: ...

class _ContentTypesItem:
    def __init__(self, parts: Sequence[Part]) -> None: ...
    @classmethod
    def xml_for(cls, parts: Sequence[Part]) -> CT_Types: ...
