from numbers import Integral
from typing import Any, ClassVar, Literal

from pptx.util import Length

class BaseSimpleType:
    @classmethod
    def from_xml(cls, xml_value: str) -> Any: ...
    @classmethod
    def to_xml(cls, value: Any) -> str: ...
    @classmethod
    def validate_float(cls, value: int | float) -> None: ...
    @classmethod
    def validate_int(cls, value: Integral) -> None: ...
    @classmethod
    def validate_float_in_range(
        cls, value: int | float, min_inclusive: int | float, max_inclusive: int | float
    ) -> None: ...
    @classmethod
    def validate_int_in_range(cls, value: Integral, min_inclusive: int, max_inclusive: int) -> None: ...
    @classmethod
    def validate_string(cls, value: str) -> str: ...

class BaseFloatType(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> float: ...
    @classmethod
    def convert_to_xml(cls, value: Any) -> str: ...
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class BaseIntType(BaseSimpleType):
    @classmethod
    def convert_from_percent_literal(cls, str_value: str) -> int: ...
    @classmethod
    def convert_from_xml(cls, str_value: str) -> int: ...
    @classmethod
    def convert_to_xml(cls, value: Integral) -> str: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class BaseStringType(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str): ...
    @classmethod
    def convert_to_xml(cls, value: str): ...
    @classmethod
    def validate(cls, value: str) -> None: ...

class BaseStringEnumerationType(BaseStringType):
    @classmethod
    def validate(cls, value: str) -> None: ...

class XsdAnyUri(BaseStringType): ...

class XsdBoolean(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> bool: ...
    @classmethod
    def convert_to_xml(cls, value: bool) -> str: ...
    @classmethod
    def validate(cls, value: bool) -> None: ...

class XsdDouble(BaseFloatType): ...
class XsdId(BaseStringType): ...

class XsdInt(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class XsdLong(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class XsdString(BaseStringType): ...
class XsdStringEnumeration(BaseStringEnumerationType): ...
class XsdToken(BaseStringType): ...
class XsdTokenEnumeration(BaseStringEnumerationType): ...

class XsdUnsignedByte(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class XsdUnsignedInt(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class XsdUnsignedShort(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Angle(XsdInt):
    DEGREE_INCREMENTS: ClassVar[int] = ...
    THREE_SIXTY: ClassVar[int] = ...
    @classmethod
    def convert_from_xml(cls, str_value: str) -> float: ...
    @classmethod
    def convert_to_xml(cls, value: int | float) -> str: ...
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_AxisUnit(XsdDouble):
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_BarDir(XsdStringEnumeration):
    BAR: ClassVar[str] = ...
    COL: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_BubbleScale(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> int: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_ContentType(XsdString): ...

class ST_Coordinate(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def convert_to_xml(cls, value: Integral) -> str: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Coordinate32(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def convert_to_xml(cls, value: Integral) -> str: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Coordinate32Unqualified(XsdInt):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...

class ST_CoordinateUnqualified(XsdLong):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Direction(XsdTokenEnumeration):
    HORZ: ClassVar[str] = ...
    VERT: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_DrawingElementId(XsdUnsignedInt): ...
class ST_Extension(XsdString): ...

class ST_GapAmount(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> int: ...
    @classmethod
    def validate(cls, valu: Integral) -> None: ...

class ST_Grouping(XsdStringEnumeration):
    CLUSTERED: ClassVar[str] = ...
    PERCENT_STACKED: ClassVar[str] = ...
    STACKED: ClassVar[str] = ...
    STANDARD: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_HexColorRGB(BaseStringType):
    @classmethod
    def convert_to_xml(cls, value: str): ...
    @classmethod
    def validate(cls, value: str) -> None: ...

class ST_LayoutMode(XsdStringEnumeration):
    EDGE: ClassVar[str] = ...
    FACTOR: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_LblOffset(XsdUnsignedShort):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> int: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_LineWidth(XsdInt):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_MarkerSize(XsdUnsignedByte):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Orientation(XsdStringEnumeration):
    MAX_MIN: ClassVar[str] = ...
    MIN_MAX: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_Overlap(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> int: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Percentage(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> float: ...
    @classmethod
    def convert_to_xml(cls, value: int | float) -> str: ...
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_PlaceholderSize(XsdTokenEnumeration):
    FULL: ClassVar[str] = ...
    HALF: ClassVar[str] = ...
    QUARTER: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_PositiveCoordinate(XsdLong):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_PositiveFixedAngle(ST_Angle):
    @classmethod
    def convert_to_xml(cls, degrees: int | float) -> str: ...

class ST_PositiveFixedPercentage(ST_Percentage):
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_RelationshipId(XsdString): ...

class ST_SlideId(XsdUnsignedInt):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_SlideSizeCoordinate(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_Style(XsdUnsignedByte):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_TargetMode(XsdString):
    @classmethod
    def validate(cls, value: Literal["External", "Internal"]) -> None: ...

class ST_TextFontScalePercentOrPercentString(BaseFloatType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> float: ...
    @classmethod
    def convert_to_xml(cls, value: int | float) -> str: ...
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_TextFontSize(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_TextIndentLevelType(BaseIntType):
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_TextSpacingPercentOrPercentString(BaseFloatType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> float: ...
    @classmethod
    def convert_to_xml(cls, value: int | float) -> str: ...
    @classmethod
    def validate(cls, value: int | float) -> None: ...

class ST_TextSpacingPoint(BaseIntType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
    @classmethod
    def convert_to_xml(cls, value: Integral) -> str: ...
    @classmethod
    def validate(cls, value: Integral) -> None: ...

class ST_TextTypeface(XsdString): ...

class ST_TextWrappingType(XsdTokenEnumeration):
    NONE: ClassVar[str] = ...
    SQUARE: ClassVar[str] = ...
    _members: ClassVar[tuple[str, ...]] = ...

class ST_UniversalMeasure(BaseSimpleType):
    @classmethod
    def convert_from_xml(cls, str_value: str) -> Length: ...
