from collections.abc import Callable, Generator
from typing import Self

from pptx.enum.text import MSO_VERTICAL_ANCHOR
from pptx.oxml.dml.fill import (
    CT_BlipFillProperties,
    CT_GradientFillProperties,
    CT_GroupFillProperties,
    CT_NoFillProperties,
    CT_PatternFillProperties,
    CT_SolidColorFillProperties,
    FillProperty,
)
from pptx.oxml.text import CT_TextBody
from pptx.oxml.xmlchemy import BaseOxmlElement
from pptx.util import Length, lazyproperty

class CT_Table(BaseOxmlElement):
    _add_tr: Callable[..., CT_TableRow]
    @property
    def tblPr(self) -> CT_TableProperties | None:
        """``<a:tblPr>`` child element or |None| if not present."""
        ...

    def get_or_add_tblPr(self) -> CT_TableProperties:
        """Return the ``<a:tblPr>`` child element, newly added if not present."""
        ...

    @property
    def tblGrid(self) -> CT_TableGrid:
        """Required ``<a:tblGrid>`` child element."""
        ...

    @property
    def tr_lst(self) -> list[CT_TableRow]:
        """A list containing each of the ``<a:tr>`` child elements, in the order they appear."""
        ...

    def add_tr(self, height: Length) -> CT_TableRow:
        """Return a newly created `a:tr` child element having its `h` attribute set to `height`."""
        ...

    @property
    def bandCol(self) -> bool: ...
    @bandCol.setter
    def bandCol(self, value: bool) -> None: ...
    @property
    def bandRow(self) -> bool: ...
    @bandRow.setter
    def bandRow(self, value: bool) -> None: ...
    @property
    def firstCol(self) -> bool: ...
    @firstCol.setter
    def firstCol(self, value: bool) -> None: ...
    @property
    def firstRow(self) -> bool: ...
    @firstRow.setter
    def firstRow(self, value: bool) -> None: ...
    def iter_tcs(self) -> Generator[CT_TableCell]: ...
    @property
    def lastCol(self) -> bool: ...
    @lastCol.setter
    def lastCol(self, value: bool) -> None: ...
    @property
    def lastRow(self) -> bool: ...
    @lastRow.setter
    def lastRow(self, value: bool) -> None: ...
    @classmethod
    def new_tbl(cls, rows: int, cols: int, width: int, height: int, tableStyleId: str | None = ...) -> CT_Table: ...
    def tc(self, row_idx: int, col_idx: int) -> CT_TableCell: ...

class CT_TableCell(BaseOxmlElement):
    @property
    def txBody(self) -> CT_TextBody | None:
        """``<a:txBody>`` child element or |None| if not present."""
        ...

    def get_or_add_txBody(self) -> CT_TextBody:
        """Return the ``<a:txBody>`` child element, newly added if not present."""
        ...

    @property
    def tcPr(self) -> CT_TableCellProperties | None:
        """``<a:tcPr>`` child element or |None| if not present."""
        ...

    def get_or_add_tcPr(self) -> CT_TableCellProperties:
        """Return the ``<a:tcPr>`` child element, newly added if not present."""
        ...

    @property
    def gridSpan(self) -> int:
        """XsdInt type-converted value of ``gridSpan`` attribute, or |1| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @gridSpan.setter
    def gridSpan(self, value: int) -> None: ...
    @property
    def rowSpan(self) -> int:
        """XsdInt type-converted value of ``rowSpan`` attribute, or |1| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @rowSpan.setter
    def rowSpan(self, value: int) -> None: ...
    @property
    def hMerge(self) -> bool:
        """XsdBoolean type-converted value of ``hMerge`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @hMerge.setter
    def hMerge(self, value: bool) -> None: ...
    @property
    def vMerge(self) -> bool:
        """XsdBoolean type-converted value of ``vMerge`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @vMerge.setter
    def vMerge(self, value: bool) -> None: ...
    @property
    def anchor(self) -> MSO_VERTICAL_ANCHOR | None: ...
    @anchor.setter
    def anchor(self, anchor_enum_idx: MSO_VERTICAL_ANCHOR | None) -> None: ...
    def append_ps_from(self, spanned_tc: CT_TableCell) -> None: ...
    @property
    def col_idx(self) -> int: ...
    @property
    def is_merge_origin(self) -> bool: ...
    @property
    def is_spanned(self) -> bool: ...
    @property
    def marT(self) -> Length: ...
    @marT.setter
    def marT(self, value: Length | None) -> None: ...
    @property
    def marR(self) -> Length: ...
    @marR.setter
    def marR(self, value: Length | None) -> None: ...
    @property
    def marB(self) -> Length: ...
    @marB.setter
    def marB(self, value: Length | None) -> None: ...
    @property
    def marL(self) -> Length: ...
    @marL.setter
    def marL(self, value: Length | None) -> None: ...
    @classmethod
    def new(cls) -> CT_TableCell: ...
    @property
    def row_idx(self) -> int: ...
    @property
    def tbl(self) -> CT_Table: ...
    @property
    def text(self) -> str: ...

class CT_TableCellProperties(BaseOxmlElement):
    @property
    def noFill(self) -> CT_NoFillProperties:
        """``<a:noFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_noFill(self) -> CT_NoFillProperties:
        """Return the ``<a:noFill>`` child, replacing any other group element if found."""
        ...

    @property
    def solidFill(self) -> CT_SolidColorFillProperties:
        """``<a:solidFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_solidFill(self) -> CT_SolidColorFillProperties:
        """Return the ``<a:solidFill>`` child, replacing any other group element if found."""
        ...

    @property
    def gradFill(self) -> CT_GradientFillProperties:
        """``<a:gradFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_gradFill(self) -> CT_GradientFillProperties:
        """Return the ``<a:gradFill>`` child, replacing any other group element if found."""
        ...

    @property
    def blipFill(self) -> CT_BlipFillProperties:
        """``<a:blipFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_blipFill(self) -> CT_BlipFillProperties:
        """Return the ``<a:blipFill>`` child, replacing any other group element if found."""
        ...

    @property
    def pattFill(self) -> CT_PatternFillProperties:
        """``<a:pattFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_pattFill(self) -> CT_PatternFillProperties:
        """Return the ``<a:pattFill>`` child, replacing any other group element if found."""
        ...

    @property
    def grpFill(self) -> CT_GroupFillProperties:
        """``<a:grpFill>`` child element or |None| if not present."""
        ...

    def get_or_change_to_grpFill(self) -> CT_GroupFillProperties:
        """Return the ``<a:grpFill>`` child, replacing any other group element if found."""
        ...

    @property
    def eg_fillProperties(
        self,
    ) -> FillProperty | None:
        """Return the child element belonging to this element group, or |None| if no member child is present."""
        ...

    @property
    def anchor(self) -> Length | None:
        """MSO_VERTICAL_ANCHOR type-converted value of ``anchor`` attribute, or |None| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @anchor.setter
    def anchor(self, value: Length | None) -> None: ...
    @property
    def marL(self) -> Length | None:
        """ST_Coordinate32 type-converted value of ``marL`` attribute, or |None| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @marL.setter
    def marL(self, value: Length | None) -> None: ...
    @property
    def marR(self) -> Length | None:
        """ST_Coordinate32 type-converted value of ``marR`` attribute, or |None| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @marR.setter
    def marR(self, value: Length | None) -> None: ...
    @property
    def marT(self) -> Length | None:
        """ST_Coordinate32 type-converted value of ``marT`` attribute, or |None| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @marT.setter
    def marT(self, value: Length | None) -> None: ...
    @property
    def marB(self) -> Length | None:
        """ST_Coordinate32 type-converted value of ``marB`` attribute, or |None| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @marB.setter
    def marB(self, value: Length | None) -> None: ...

class CT_TableCol(BaseOxmlElement):
    @property
    def w(self) -> Length:
        """ST_Coordinate type-converted value of ``w`` attribute."""
        ...

    @w.setter
    def w(self, value: Length) -> None: ...

class CT_TableGrid(BaseOxmlElement):
    @property
    def gridCol_lst(self) -> list[CT_TableCol]:
        """A list containing each of the ``<a:gridCol>`` child elements, in the order they appear."""
        ...

    def add_gridCol(self, width: Length) -> CT_TableCol: ...

class CT_TableProperties(BaseOxmlElement):
    @property
    def bandRow(self) -> bool:
        """XsdBoolean type-converted value of ``bandRow`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @bandRow.setter
    def bandRow(self, value: bool) -> None: ...
    @property
    def bandCol(self) -> bool:
        """XsdBoolean type-converted value of ``bandCol`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @bandCol.setter
    def bandCol(self, value: bool) -> None: ...
    @property
    def firstRow(self) -> bool:
        """XsdBoolean type-converted value of ``firstRow`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @firstRow.setter
    def firstRow(self, value: bool) -> None: ...
    @property
    def firstCol(self) -> bool:
        """XsdBoolean type-converted value of ``firstCol`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @firstCol.setter
    def firstCol(self, value: bool) -> None: ...
    @property
    def lastRow(self) -> bool:
        """XsdBoolean type-converted value of ``lastRow`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @lastRow.setter
    def lastRow(self, value: bool) -> None: ...
    @property
    def lastCol(self) -> bool:
        """XsdBoolean type-converted value of ``lastCol`` attribute, or |False| if not present. Assigning the default value causes the attribute to be removed from the element."""
        ...

    @lastCol.setter
    def lastCol(self, value: bool) -> None: ...

class CT_TableRow(BaseOxmlElement):
    @property
    def tc_lst(self) -> list[CT_TableCell]:
        """A list containing each of the ``<a:tc>`` child elements, in the order they appear."""
        ...

    @property
    def h(self) -> Length:
        """ST_Coordinate type-converted value of ``h`` attribute."""
        ...

    @h.setter
    def h(self, value: Length) -> None: ...
    def add_tc(self) -> CT_TableCell: ...
    @property
    def row_idx(self) -> int: ...

class TcRange:
    def __init__(self, tc: CT_TableCell, other_tc: CT_TableCell) -> None: ...
    @classmethod
    def from_merge_origin(cls, tc: CT_TableCell) -> Self: ...
    @lazyproperty
    def contains_merged_cell(self) -> bool: ...
    @lazyproperty
    def dimensions(self) -> tuple[int, int]: ...
    @lazyproperty
    def in_same_table(self) -> bool: ...
    def iter_except_left_col_tcs(self) -> Generator[CT_TableCell]: ...
    def iter_except_top_row_tcs(self) -> Generator[CT_TableCell]: ...
    def iter_left_col_tcs(self) -> Generator[CT_TableCell]: ...
    def iter_tcs(self) -> Generator[CT_TableCell]: ...
    def iter_top_row_tcs(self) -> Generator[CT_TableCell]: ...
    def move_content_to_origin(self) -> None: ...
