from collections.abc import Iterable, Sequence
from re import Pattern
from typing import Any, Protocol

from lxml import etree
from lxml.etree import ElementBase, _Element

class AttributeType(Protocol):
    @classmethod
    def from_xml(cls, xml_value: str) -> Any: ...
    @classmethod
    def to_xml(cls, value: Any) -> str: ...

def OxmlElement(nsptag_str: str, nsmap: dict[str, str] | None = ...) -> BaseOxmlElement | _Element: ...
def serialize_for_reading(element: ElementBase) -> XmlString: ...

class XmlString(str):
    _xml_elm_line_patt: Pattern[str] = ...

    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class MetaOxmlElement(type):
    def __init__(cls, clsname: str, bases: tuple[type, ...], clsdict: dict[str, Any]) -> None: ...

class BaseAttribute:
    def __init__(self, attr_name: str, simple_type: type[AttributeType]) -> None: ...
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class OptionalAttribute(BaseAttribute):
    def __init__(self, attr_name: str, simple_type: type[AttributeType], default: Any = ...) -> None: ...

class RequiredAttribute(BaseAttribute): ...

class _BaseChildElement:
    def __init__(self, nsptagname: str, successors: Sequence[str] = ...) -> None: ...
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class Choice(_BaseChildElement):
    @property
    def nsptagname(self) -> str: ...
    def populate_class_members(
        self, element_cls: type[BaseOxmlElement], group_prop_name: str, successors: Sequence[str]
    ) -> None: ...

class OneAndOnlyOne(_BaseChildElement):
    def __init__(self, nsptagname: str) -> None: ...
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class OneOrMore(_BaseChildElement):
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class ZeroOrMore(_BaseChildElement):
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class ZeroOrOne(_BaseChildElement):
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class ZeroOrOneChoice(_BaseChildElement):
    def __init__(self, choices: Iterable[Choice], successors: Iterable[str] = ...) -> None: ...
    def populate_class_members(self, element_cls: type[BaseOxmlElement], prop_name: str) -> None: ...

class BaseOxmlElement(etree.ElementBase):
    def __repr__(self) -> str: ...
    def first_child_found_in(self, *tagnames: str) -> _Element | None: ...
    def insert_element_before(self, elm: ElementBase, *tagnames: str) -> ElementBase: ...
    def remove_all(self, *tagnames: str) -> None: ...
    @property
    def xml(self) -> str: ...
    def xpath(self, xpath_str: str) -> Any: ...
