from collections.abc import Generator, Iterator
from typing import IO

from pptx.media import Video
from pptx.opc.package import OpcPackage
from pptx.opc.packuri import PackURI
from pptx.parts.coreprops import CorePropertiesPart
from pptx.parts.image import ImagePart
from pptx.parts.media import MediaPart
from pptx.parts.presentation import PresentationPart
from pptx.util import lazyproperty

class Package(OpcPackage):
    @lazyproperty
    def core_properties(self) -> CorePropertiesPart: ...
    def get_or_add_image_part(self, image_file: str | IO[bytes]) -> ImagePart: ...
    def get_or_add_media_part(self, media: Video) -> MediaPart: ...
    def next_image_partname(self, ext: str) -> PackURI: ...
    def next_media_partname(self, ext: str) -> PackURI: ...
    @property
    def presentation_part(self) -> PresentationPart: ...

class _ImageParts:
    _package: Package
    def __init__(self, package: Package) -> None: ...
    def __iter__(self) -> Iterator[ImagePart]: ...
    def get_or_add_image_part(self, image_file: str | IO[bytes]) -> ImagePart: ...

class _MediaParts:
    _package: Package
    def __init__(self, package: Package) -> None: ...
    def __iter__(self) -> Generator[MediaPart]: ...
    def get_or_add_media_part(self, media: Video) -> MediaPart: ...
