from typing import Self

from pptx.enum.shapes import PROG_ID
from pptx.opc.package import Part
from pptx.package import Package
from pptx.util import lazyproperty

class EmbeddedPackagePart(Part):
    @classmethod
    def factory(cls, prog_id: PROG_ID | str, object_blob: bytes, package: Package) -> Self: ...
    @classmethod
    def new(cls, blob: bytes, package: Package) -> Self: ...

class EmbeddedDocxPart(EmbeddedPackagePart):
    partname_template: str = ...
    content_type: lazyproperty[str] = ...

class EmbeddedPptxPart(EmbeddedPackagePart):
    partname_template: str = ...
    content_type: lazyproperty[str] = ...

class EmbeddedXlsxPart(EmbeddedPackagePart):
    partname_template: str = ...
    content_type: lazyproperty[str] = ...
