from typing import IO

from pptx.opc.package import Part
from pptx.opc.packuri import PackURI
from pptx.package import Package
from pptx.util import lazyproperty

class ImagePart(Part):
    def __init__(
        self, partname: PackURI, content_type: str, package: Package, blob: bytes, filename: str | None = ...
    ) -> None: ...
    @classmethod
    def new(cls, package: Package, image: Image) -> ImagePart: ...
    @property
    def desc(self) -> str: ...
    @property
    def ext(self) -> str: ...
    @property
    def image(self) -> Image: ...
    def scale(self, scaled_cx: int | None, scaled_cy: int | None) -> tuple[int, int]: ...
    @lazyproperty
    def sha1(self) -> str: ...

class Image:
    def __init__(self, blob: bytes, filename: str | None) -> None: ...
    @classmethod
    def from_blob(cls, blob: bytes, filename: str | None = ...) -> Image: ...
    @classmethod
    def from_file(cls, image_file: str | IO[bytes]) -> Image: ...
    @property
    def blob(self) -> bytes: ...
    @lazyproperty
    def content_type(self) -> str: ...
    @lazyproperty
    def dpi(self) -> tuple[int, int]: ...
    @lazyproperty
    def ext(self) -> str: ...
    @property
    def filename(self) -> str | None: ...
    @lazyproperty
    def sha1(self) -> str: ...
    @lazyproperty
    def size(self) -> tuple[int, int]: ...
