from collections.abc import Iterable
from typing import IO

from pptx.opc.package import XmlPart
from pptx.parts.coreprops import CorePropertiesPart
from pptx.parts.slide import NotesMasterPart, SlidePart
from pptx.presentation import Presentation
from pptx.slide import NotesMaster, Slide, SlideLayout, SlideMaster
from pptx.util import lazyproperty

class PresentationPart(XmlPart):
    def add_slide(self, slide_layout: SlideLayout) -> tuple[str, Slide]: ...
    @property
    def core_properties(self) -> CorePropertiesPart: ...
    def get_slide(self, slide_id: int) -> Slide | None: ...
    @lazyproperty
    def notes_master(self) -> NotesMaster: ...
    @lazyproperty
    def notes_master_part(self) -> NotesMasterPart: ...
    @lazyproperty
    def presentation(self) -> Presentation: ...
    def related_slide(self, rId: str) -> Slide: ...
    def related_slide_master(self, rId: str) -> SlideMaster: ...
    def rename_slide_parts(self, rIds: Iterable[str]) -> None: ...
    def save(self, path_or_stream: str | IO[bytes]) -> None: ...
    def slide_id(self, slide_part: SlidePart) -> int: ...
