from typing import IO, Self

from pptx.chart.data import ChartData
from pptx.enum.chart import XL_CHART_TYPE
from pptx.enum.shapes import PROG_ID
from pptx.media import Video
from pptx.opc.package import Part, XmlPart
from pptx.opc.packuri import PackURI
from pptx.oxml.slide import CT_Slide
from pptx.package import Package
from pptx.parts.image import Image, ImagePart
from pptx.slide import NotesMaster, NotesSlide, Slide, SlideLayout, SlideMaster
from pptx.util import lazyproperty

class BaseSlidePart(XmlPart):
    _element: CT_Slide

    def get_image(self, rId: str) -> Image: ...
    def get_or_add_image_part(self, image_file: str | IO[bytes]) -> tuple[ImagePart, str]: ...
    @property
    def name(self) -> str: ...

class NotesMasterPart(BaseSlidePart):
    @classmethod
    def create_default(cls, package: Package) -> NotesMasterPart: ...
    @lazyproperty
    def notes_master(self) -> NotesMaster: ...

class NotesSlidePart(BaseSlidePart):
    @classmethod
    def new(cls, package: Package, slide_part: SlidePart) -> NotesSlidePart: ...
    @lazyproperty
    def notes_master(self): ...
    @lazyproperty
    def notes_slide(self) -> NotesSlide: ...

class SlidePart(BaseSlidePart):
    @classmethod
    def new(cls, partname: PackURI, package: Package, slide_layout_part: Part | str) -> Self: ...
    def add_chart_part(self, chart_type: XL_CHART_TYPE, chart_data: ChartData) -> str: ...
    def add_embedded_ole_object_part(self, prog_id: PROG_ID | str, ole_object_file: str | IO[bytes]) -> str: ...
    def get_or_add_video_media_part(self, video: Video) -> tuple[str, str]: ...
    @property
    def has_notes_slide(self) -> bool: ...
    @lazyproperty
    def notes_slide(self) -> NotesSlide: ...
    @lazyproperty
    def slide(self) -> Slide: ...
    @property
    def slide_id(self) -> int: ...
    @property
    def slide_layout(self) -> SlideLayout: ...

class SlideLayoutPart(BaseSlidePart):
    @lazyproperty
    def slide_layout(self) -> SlideLayout: ...
    @property
    def slide_master(self) -> SlideMaster: ...

class SlideMasterPart(BaseSlidePart):
    def related_slide_layout(self, rId: str) -> SlideLayout: ...
    @lazyproperty
    def slide_master(self) -> SlideMaster: ...
