from typing import IO

from pptx.oxml.presentation import CT_Presentation
from pptx.parts.coreprops import CorePropertiesPart
from pptx.parts.presentation import PresentationPart
from pptx.shared import PartElementProxy
from pptx.slide import NotesMaster, SlideLayouts, SlideMaster, SlideMasters, Slides
from pptx.util import Length, lazyproperty

class Presentation(PartElementProxy):
    _element: CT_Presentation
    part: PresentationPart

    @property
    def core_properties(self) -> CorePropertiesPart: ...
    @property
    def notes_master(self) -> NotesMaster: ...
    def save(self, file: str | IO[bytes]) -> None: ...
    @property
    def slide_height(self) -> Length | None: ...
    @slide_height.setter
    def slide_height(self, height: Length) -> None: ...
    @property
    def slide_layouts(self) -> SlideLayouts: ...
    @property
    def slide_master(self) -> SlideMaster: ...
    @lazyproperty
    def slide_masters(self) -> SlideMasters: ...
    @property
    def slide_width(self) -> Length | None: ...
    @slide_width.setter
    def slide_width(self, width: Length) -> None: ...
    @lazyproperty
    def slides(self) -> Slides: ...
