from pptx.dml.fill import FillFormat
from pptx.dml.line import LineFormat
from pptx.enum.shapes import MSO_AUTO_SHAPE_TYPE, MSO_SHAPE_TYPE
from pptx.oxml.shapes.autoshape import CT_PresetGeometry2D, CT_Shape
from pptx.oxml.shapes.shared import CT_LineProperties
from pptx.shapes.base import BaseShape
from pptx.spec import AdjustmentValue
from pptx.text.text import TextFrame
from pptx.types import ProvidesPart
from pptx.util import lazyproperty

class Adjustment:
    def __init__(self, name: str, def_val: int, actual: int | None = ...) -> None: ...
    @property
    def effective_value(self) -> float: ...
    @effective_value.setter
    def effective_value(self, value: float) -> None: ...
    @property
    def val(self) -> int: ...

class AdjustmentCollection:
    def __init__(self, prstGeom: CT_PresetGeometry2D) -> None: ...
    def __getitem__(self, idx: int) -> float: ...
    def __setitem__(self, idx: int, value: float) -> None: ...
    def __len__(self) -> int: ...

class AutoShapeType:
    _instances: dict[MSO_AUTO_SHAPE_TYPE, AutoShapeType] = ...
    def __new__(cls, autoshape_type_id: MSO_AUTO_SHAPE_TYPE) -> AutoShapeType: ...
    def __init__(self, autoshape_type_id: MSO_AUTO_SHAPE_TYPE) -> None: ...
    @property
    def autoshape_type_id(self) -> MSO_AUTO_SHAPE_TYPE: ...
    @property
    def basename(self) -> str: ...
    @classmethod
    def default_adjustment_values(cls, prst: MSO_AUTO_SHAPE_TYPE) -> tuple[AdjustmentValue, ...]: ...
    @classmethod
    def id_from_prst(cls, prst: str) -> MSO_AUTO_SHAPE_TYPE: ...
    @property
    def prst(self) -> str: ...

class Shape(BaseShape):
    _element: CT_Shape
    _sp: CT_Shape
    def __init__(self, sp: CT_Shape, parent: ProvidesPart) -> None: ...
    @lazyproperty
    def adjustments(self) -> AdjustmentCollection: ...
    @property
    def auto_shape_type(self) -> MSO_AUTO_SHAPE_TYPE | None: ...
    @lazyproperty
    def fill(self) -> FillFormat: ...
    def get_or_add_ln(self) -> CT_LineProperties: ...
    @property
    def has_text_frame(self) -> bool: ...
    @lazyproperty
    def line(self) -> LineFormat: ...
    @property
    def ln(self) -> CT_LineProperties | None: ...
    @property
    def shape_type(self) -> MSO_SHAPE_TYPE: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...
    @property
    def text_frame(self) -> TextFrame: ...
