from pptx.action import ActionSetting
from pptx.dml.effect import ShadowFormat
from pptx.enum.shapes import MSO_SHAPE_TYPE, PP_PLACEHOLDER
from pptx.oxml.shapes import ShapeElement
from pptx.oxml.shapes.shared import CT_Placeholder
from pptx.parts.slide import BaseSlidePart
from pptx.shared import ElementProxy
from pptx.types import ProvidesPart
from pptx.util import Length, lazyproperty

class BaseShape:
    _element: ShapeElement
    _parent: ProvidesPart
    def __init__(self, shape_elm: ShapeElement, parent: ProvidesPart) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @lazyproperty
    def click_action(self) -> ActionSetting: ...
    @property
    def element(self) -> ShapeElement: ...
    @property
    def has_chart(self) -> bool: ...
    @property
    def has_table(self) -> bool: ...
    @property
    def has_text_frame(self) -> bool: ...
    @property
    def height(self) -> Length: ...
    @height.setter
    def height(self, value: Length) -> None: ...
    @property
    def is_placeholder(self) -> bool: ...
    @property
    def left(self) -> Length: ...
    @left.setter
    def left(self, value: Length) -> None: ...
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, value: str) -> None: ...
    @property
    def part(self) -> BaseSlidePart: ...
    @property
    def placeholder_format(self) -> _PlaceholderFormat: ...
    @property
    def rotation(self) -> float: ...
    @rotation.setter
    def rotation(self, value: float) -> None: ...
    @lazyproperty
    def shadow(self) -> ShadowFormat: ...
    @property
    def shape_id(self) -> int: ...
    @property
    def shape_type(self) -> MSO_SHAPE_TYPE: ...
    @property
    def top(self) -> Length: ...
    @top.setter
    def top(self, value: Length) -> None: ...
    @property
    def width(self) -> Length: ...
    @width.setter
    def width(self, value: Length) -> None: ...

class _PlaceholderFormat(ElementProxy):
    def __init__(self, element: CT_Placeholder) -> None: ...
    @property
    def element(self) -> CT_Placeholder: ...
    @property
    def idx(self) -> int: ...
    @property
    def type(self) -> PP_PLACEHOLDER: ...
