from typing import Literal

from pptx.dml.line import LineFormat
from pptx.enum.shapes import MSO_SHAPE_TYPE
from pptx.oxml.shapes.shared import CT_LineProperties
from pptx.shapes.base import BaseShape
from pptx.util import Length, lazyproperty

class Connector(BaseShape):
    def begin_connect(self, shape: BaseShape, cxn_pt_idx: int) -> None: ...
    @property
    def begin_x(self) -> Length: ...
    @begin_x.setter
    def begin_x(self, value: Length) -> None: ...
    @property
    def begin_y(self) -> Length: ...
    @begin_y.setter
    def begin_y(self, value: Length) -> None: ...
    def end_connect(self, shape: BaseShape, cxn_pt_idx: int) -> None: ...
    @property
    def end_x(self) -> Length: ...
    @end_x.setter
    def end_x(self, value: Length) -> None: ...
    @property
    def end_y(self) -> Length: ...
    @end_y.setter
    def end_y(self, value: Length) -> None: ...
    def get_or_add_ln(self) -> CT_LineProperties: ...
    @lazyproperty
    def line(self) -> LineFormat: ...
    @property
    def ln(self) -> CT_LineProperties | None: ...
    @property
    def shape_type(self) -> Literal[MSO_SHAPE_TYPE.LINE]: ...
