from collections.abc import Iterable, Iterator, Sequence
from typing import Self

from pptx.oxml.shapes.autoshape import CT_Path2D, CT_Path2DClose, CT_Path2DLineTo, CT_Path2DMoveTo
from pptx.shapes.base import BaseShape
from pptx.shapes.shapetree import _BaseGroupShapes
from pptx.util import Length

type CT_DrawingOperation = "CT_Path2DClose | CT_Path2DLineTo | CT_Path2DMoveTo"
type DrawingOperation = "_LineSegment | _MoveTo | _Close"

class FreeformBuilder(Sequence[DrawingOperation]):
    def __init__(
        self, shapes: _BaseGroupShapes, start_x: Length, start_y: Length, x_scale: float, y_scale: float
    ) -> None: ...
    def __getitem__(self, idx: int) -> DrawingOperation: ...
    def __iter__(self) -> Iterator[DrawingOperation]: ...
    def __len__(self) -> int: ...
    @classmethod
    def new(cls, shapes: _BaseGroupShapes, start_x: float, start_y: float, x_scale: float, y_scale: float) -> Self: ...
    def add_line_segments(self, vertices: Iterable[tuple[float, float]], close: bool = ...) -> Self: ...
    def convert_to_shape(self, origin_x: Length = ..., origin_y: Length = ...) -> BaseShape: ...
    def move_to(self, x: float, y: float) -> Self: ...
    @property
    def shape_offset_x(self) -> Length: ...
    @property
    def shape_offset_y(self) -> Length: ...

class _BaseDrawingOperation:
    def __init__(self, freeform_builder: FreeformBuilder, x: Length, y: Length) -> None: ...
    def apply_operation_to(self, path: CT_Path2D) -> CT_DrawingOperation: ...
    @property
    def x(self) -> Length: ...
    @property
    def y(self) -> Length: ...

class _Close:
    @classmethod
    def new(cls) -> _Close: ...
    def apply_operation_to(self, path: CT_Path2D) -> CT_Path2DClose: ...

class _LineSegment(_BaseDrawingOperation):
    @classmethod
    def new(cls, freeform_builder: FreeformBuilder, x: float, y: float) -> _LineSegment: ...
    def apply_operation_to(self, path: CT_Path2D) -> CT_Path2DLineTo: ...

class _MoveTo(_BaseDrawingOperation):
    @classmethod
    def new(cls, freeform_builder: FreeformBuilder, x: float, y: float) -> _MoveTo: ...
    def apply_operation_to(self, path: CT_Path2D) -> CT_Path2DMoveTo: ...
