from pptx.dml.line import LineFormat
from pptx.enum.shapes import MSO_SHAPE, MSO_SHAPE_TYPE, PP_MEDIA_TYPE
from pptx.oxml.shapes.picture import CT_Picture
from pptx.oxml.shapes.shared import CT_LineProperties
from pptx.parts.image import Image
from pptx.shapes.base import BaseShape
from pptx.shared import ParentedElementProxy
from pptx.types import ProvidesPart
from pptx.util import lazyproperty

class _BasePicture(BaseShape):
    _element: CT_Picture
    _pic: CT_Picture
    def __init__(self, pic: CT_Picture, parent: ProvidesPart) -> None: ...
    @property
    def crop_bottom(self) -> float: ...
    @crop_bottom.setter
    def crop_bottom(self, value: float) -> None: ...
    @property
    def crop_left(self) -> float: ...
    @crop_left.setter
    def crop_left(self, value: float) -> None: ...
    @property
    def crop_right(self) -> float: ...
    @crop_right.setter
    def crop_right(self, value: float) -> None: ...
    @property
    def crop_top(self) -> float: ...
    @crop_top.setter
    def crop_top(self, value: float) -> None: ...
    def get_or_add_ln(self) -> CT_LineProperties: ...
    @lazyproperty
    def line(self) -> LineFormat: ...
    @property
    def ln(self) -> CT_LineProperties | None: ...

class Movie(_BasePicture):
    @lazyproperty
    def media_format(self) -> _MediaFormat: ...
    @property
    def media_type(self) -> PP_MEDIA_TYPE: ...
    @property
    def poster_frame(self) -> Image | None: ...
    @property
    def shape_type(self) -> MSO_SHAPE_TYPE: ...

class Picture(_BasePicture):
    @property
    def auto_shape_type(self) -> MSO_SHAPE | None: ...
    @auto_shape_type.setter
    def auto_shape_type(self, member: MSO_SHAPE) -> None: ...
    @property
    def image(self) -> Image: ...
    @property
    def shape_type(self) -> MSO_SHAPE_TYPE: ...

class _MediaFormat(ParentedElementProxy): ...
