from pptx.opc.package import XmlPart
from pptx.oxml.xmlchemy import BaseOxmlElement
from pptx.types import ProvidesPart

class ElementProxy:
    _element: BaseOxmlElement
    def __init__(self, element: BaseOxmlElement) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def element(self) -> BaseOxmlElement: ...

class ParentedElementProxy(ElementProxy):
    _parent: ProvidesPart
    def __init__(self, element: BaseOxmlElement, parent: ProvidesPart) -> None: ...
    @property
    def parent(self) -> ProvidesPart: ...
    @property
    def part(self) -> XmlPart: ...

class PartElementProxy(ElementProxy):
    _part: XmlPart
    def __init__(self, element: BaseOxmlElement, part: XmlPart) -> None: ...
    @property
    def part(self) -> XmlPart: ...
