from collections.abc import Generator, Iterator

from pptx.dml.fill import FillFormat
from pptx.oxml.presentation import CT_SlideIdList, CT_SlideMasterIdList
from pptx.oxml.slide import CT_CommonSlideData, CT_NotesSlide, CT_Slide, CT_SlideLayoutIdList, CT_SlideMaster
from pptx.parts.presentation import PresentationPart
from pptx.parts.slide import SlideLayoutPart, SlideMasterPart, SlidePart
from pptx.presentation import Presentation
from pptx.shapes.placeholder import LayoutPlaceholder, NotesSlidePlaceholder
from pptx.shapes.shapetree import (
    LayoutPlaceholders,
    LayoutShapes,
    MasterPlaceholders,
    MasterShapes,
    NotesSlidePlaceholders,
    NotesSlideShapes,
    SlidePlaceholders,
    SlideShapes,
)
from pptx.shared import ElementProxy, ParentedElementProxy, PartElementProxy
from pptx.text.text import TextFrame
from pptx.util import lazyproperty

class _BaseSlide(PartElementProxy):
    _element: CT_Slide
    @property
    def element(self) -> CT_Slide: ...
    @lazyproperty
    def background(self) -> _Background: ...
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, value: str | None) -> None: ...

class _BaseMaster(_BaseSlide):
    @lazyproperty
    def placeholders(self) -> MasterPlaceholders: ...
    @lazyproperty
    def shapes(self) -> MasterShapes: ...

class NotesMaster(_BaseMaster): ...

class NotesSlide(_BaseSlide):
    _element: CT_NotesSlide
    def clone_master_placeholders(self, notes_master: NotesMaster) -> None: ...
    @property
    def element(self) -> CT_NotesSlide: ...
    @property
    def notes_placeholder(self) -> NotesSlidePlaceholder | None: ...
    @property
    def notes_text_frame(self) -> TextFrame | None: ...
    @lazyproperty
    def placeholders(self) -> NotesSlidePlaceholders: ...
    @lazyproperty
    def shapes(self) -> NotesSlideShapes: ...

class Slide(_BaseSlide):
    _part: SlidePart
    @property
    def part(self) -> SlidePart: ...
    @property
    def follow_master_background(self) -> bool: ...
    @property
    def has_notes_slide(self) -> bool: ...
    @property
    def notes_slide(self) -> NotesSlide: ...
    @lazyproperty
    def placeholders(self) -> SlidePlaceholders: ...
    @lazyproperty
    def shapes(self) -> SlideShapes: ...
    @property
    def slide_id(self) -> int: ...
    @property
    def slide_layout(self) -> SlideLayout: ...

class Slides(ParentedElementProxy):
    _element: CT_SlideIdList
    _parent: Presentation
    _part: PresentationPart
    def __init__(self, sldIdLst: CT_SlideIdList, prs: Presentation) -> None: ...
    def __getitem__(self, idx: int) -> Slide: ...
    def __iter__(self) -> Generator[Slide]: ...
    def __len__(self) -> int: ...
    def add_slide(self, slide_layout: SlideLayout) -> Slide: ...
    def get(self, slide_id: int, default: Slide | None = ...) -> Slide | None: ...
    def index(self, slide: Slide) -> int: ...
    @property
    def element(self) -> CT_SlideIdList: ...
    @property
    def parent(self) -> Presentation: ...
    @property
    def part(self) -> PresentationPart: ...

class SlideLayout(_BaseSlide):
    _part: SlideLayoutPart
    def iter_cloneable_placeholders(self) -> Iterator[LayoutPlaceholder]: ...
    @property
    def part(self) -> SlideLayoutPart: ...
    @lazyproperty
    def placeholders(self) -> LayoutPlaceholders: ...
    @lazyproperty
    def shapes(self) -> LayoutShapes: ...
    @property
    def slide_master(self) -> SlideMaster: ...
    @property
    def used_by_slides(self) -> tuple[Slide, ...]: ...

class SlideLayouts(ParentedElementProxy):
    _element: CT_SlideLayoutIdList
    _parent: SlideMaster
    _part: SlideMasterPart
    def __init__(self, sldLayoutIdLst: CT_SlideLayoutIdList, parent: SlideMaster) -> None: ...
    def __getitem__(self, idx: int) -> SlideLayout: ...
    def __iter__(self) -> Iterator[SlideLayout]: ...
    def __len__(self) -> int: ...
    def get_by_name(self, name: str, default: SlideLayout | None = ...) -> SlideLayout | None: ...
    def index(self, slide_layout: SlideLayout) -> int: ...
    def remove(self, slide_layout: SlideLayout) -> None: ...
    @property
    def element(self) -> CT_SlideLayoutIdList: ...
    @property
    def parent(self) -> SlideMaster: ...
    @property
    def part(self) -> SlideMasterPart: ...

class SlideMaster(_BaseMaster):
    _element: CT_SlideMaster
    @property
    def element(self) -> CT_SlideMaster: ...
    @lazyproperty
    def slide_layouts(self) -> SlideLayouts: ...

class SlideMasters(ParentedElementProxy):
    _element: CT_SlideMasterIdList
    _parent: Presentation
    _part: PresentationPart
    def __init__(self, sldMasterIdLst: CT_SlideMasterIdList, parent: Presentation) -> None: ...
    def __getitem__(self, idx: int) -> SlideMaster: ...
    def __iter__(self) -> Generator[SlideMaster]: ...
    def __len__(self) -> int: ...
    @property
    def element(self) -> CT_SlideMasterIdList: ...
    @property
    def parent(self) -> Presentation: ...
    @property
    def part(self) -> PresentationPart: ...

class _Background(ElementProxy):
    _element: CT_CommonSlideData
    def __init__(self, cSld: CT_CommonSlideData) -> None: ...
    @property
    def element(self) -> CT_CommonSlideData: ...
    @lazyproperty
    def fill(self) -> FillFormat: ...
