from collections.abc import Generator, Iterator

from pptx.dml.fill import FillFormat
from pptx.enum.text import MSO_VERTICAL_ANCHOR
from pptx.oxml.table import CT_Table, CT_TableCell, CT_TableCol, CT_TableRow
from pptx.parts.slide import BaseSlidePart
from pptx.shapes import Subshape
from pptx.shapes.graphfrm import GraphicFrame
from pptx.text.text import TextFrame
from pptx.types import ProvidesPart
from pptx.util import Length, lazyproperty

class Table:
    _tbl: CT_Table
    _graphic_frame: GraphicFrame
    def __init__(self, tbl: CT_Table, graphic_frame: GraphicFrame) -> None: ...
    def cell(self, row_idx: int, col_idx: int) -> _Cell: ...
    @lazyproperty
    def columns(self) -> _ColumnCollection: ...
    @property
    def first_col(self) -> bool: ...
    @first_col.setter
    def first_col(self, value: bool) -> None: ...
    @property
    def first_row(self) -> bool: ...
    @first_row.setter
    def first_row(self, value: bool) -> None: ...
    @property
    def horz_banding(self) -> bool: ...
    @horz_banding.setter
    def horz_banding(self, value: bool) -> None: ...
    def iter_cells(self) -> Iterator[_Cell]: ...
    @property
    def last_col(self) -> bool: ...
    @last_col.setter
    def last_col(self, value: bool) -> None: ...
    @property
    def last_row(self) -> bool: ...
    @last_row.setter
    def last_row(self, value: bool) -> None: ...
    def notify_height_changed(self) -> None: ...
    def notify_width_changed(self) -> None: ...
    @property
    def part(self) -> BaseSlidePart: ...
    @lazyproperty
    def rows(self) -> _RowCollection: ...
    @property
    def vert_banding(self) -> bool: ...
    @vert_banding.setter
    def vert_banding(self, value: bool) -> None: ...

class _Cell(Subshape):
    _tc: CT_TableCell
    def __init__(self, tc: CT_TableCell, parent: ProvidesPart) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @lazyproperty
    def fill(self) -> FillFormat: ...
    @property
    def is_merge_origin(self) -> bool: ...
    @property
    def is_spanned(self) -> bool: ...
    @property
    def margin_left(self) -> Length: ...
    @margin_left.setter
    def margin_left(self, margin_left: Length | None) -> None: ...
    @property
    def margin_right(self) -> Length: ...
    @margin_right.setter
    def margin_right(self, margin_right: Length | None) -> None: ...
    @property
    def margin_top(self) -> Length: ...
    @margin_top.setter
    def margin_top(self, margin_top: Length | None) -> None: ...
    @property
    def margin_bottom(self) -> Length: ...
    @margin_bottom.setter
    def margin_bottom(self, margin_bottom: Length | None) -> None: ...
    def merge(self, other_cell: _Cell) -> None: ...
    @property
    def span_height(self) -> int: ...
    @property
    def span_width(self) -> int: ...
    def split(self) -> None: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...
    @property
    def text_frame(self) -> TextFrame: ...
    @property
    def vertical_anchor(self) -> MSO_VERTICAL_ANCHOR | None: ...
    @vertical_anchor.setter
    def vertical_anchor(self, mso_anchor_idx: MSO_VERTICAL_ANCHOR | None) -> None: ...

class _Column(Subshape):
    _parent: _ColumnCollection
    _gridCol: CT_TableCol
    def __init__(self, gridCol: CT_TableCol, parent: _ColumnCollection) -> None: ...
    @property
    def width(self) -> Length: ...
    @width.setter
    def width(self, width: Length) -> None: ...

class _Row(Subshape):
    _parent: _RowCollection
    _tr: CT_TableRow
    def __init__(self, tr: CT_TableRow, parent: _RowCollection) -> None: ...
    @property
    def cells(self) -> _CellCollection: ...
    @property
    def height(self) -> Length: ...
    @height.setter
    def height(self, height: Length) -> None: ...

class _CellCollection(Subshape):
    _parent: _Row
    _tr: CT_TableRow
    def __init__(self, tr: CT_TableRow, parent: _Row) -> None: ...
    def __getitem__(self, idx: int) -> _Cell: ...
    def __iter__(self) -> Generator[_Cell]: ...
    def __len__(self) -> int: ...

class _ColumnCollection(Subshape):
    _parent: Table
    _tbl: CT_Table
    def __init__(self, tbl: CT_Table, parent: Table) -> None: ...
    def __getitem__(self, idx: int) -> _Column: ...
    def __len__(self) -> int: ...
    def notify_width_changed(self) -> None: ...

class _RowCollection(Subshape):
    _parent: Table
    _tbl: CT_Table
    def __init__(self, tbl: CT_Table, parent: Table) -> None: ...
    def __getitem__(self, idx: int) -> _Row: ...
    def __len__(self) -> int: ...
    def notify_height_changed(self) -> None: ...
