from os import PathLike
from typing import IO, Self

class FontFiles:
    _font_files: dict[tuple[str, bool, bool] : PathLike | str] | None = ...
    @classmethod
    def find(cls, family_name: str, is_bold: bool, is_italic: bool) -> str: ...

class _Font:
    _stream: _Stream
    def __init__(self, stream: _Stream) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, exception_type, exception_value, exception_tb) -> None: ...
    @property
    def is_bold(self) -> bool: ...
    @property
    def is_italic(self) -> bool: ...
    @classmethod
    def open(cls, font_file_path: PathLike | str) -> Self: ...
    @property
    def family_name(self) -> str: ...

class _Stream:
    _file: IO[bytes]
    def __init__(self, file: IO[bytes]) -> None: ...
    @classmethod
    def open(cls, path: PathLike | str) -> Self: ...
    def close(self) -> None: ...
    def read(self, offset: int, length: int): ...
    def read_fields(self, template: str, offset: int = ...) -> tuple: ...

class _BaseTable:
    _stream: _Stream
    _offset: int
    _length: int
    def __init__(self, tag, stream: _Stream, offset: int, length: int) -> None: ...

class _HeadTable(_BaseTable):
    def __init__(self, tag, stream: _Stream, offset: int, length: int) -> None: ...
    @property
    def is_bold(self) -> bool: ...
    @property
    def is_italic(self) -> bool: ...

class _NameTable(_BaseTable):
    def __init__(self, tag, stream: _Stream, offset: int, length: int) -> None: ...
    @property
    def family_name(self) -> str | None: ...
