from collections.abc import Callable, Generator, Iterable
from os import PathLike
from typing import Any, Self

from PIL import ImageFont
from pptx.util import Length

class TextFitter(tuple):
    def __new__(cls, line_source: _LineSource, extents: tuple[Length, Length], font_file: str) -> Self: ...
    @classmethod
    def best_fit_font_size(cls, text: str, extents: tuple[Length, Length], max_size: int, font_file: str) -> int: ...

class _BinarySearchTree:
    _lesser: _BinarySearchTree | None
    _greater: _BinarySearchTree | None

    def __init__(self, value: Any) -> None: ...
    def find_max(self, predicate: Callable[[Any], bool], max_: Any = ...) -> Any | None: ...
    @classmethod
    def from_ordered_sequence(cls, iseq: Iterable[Any]) -> Self: ...
    def insert(self, value: Any) -> None: ...
    def tree(self, level: int = ..., prefix: str = ...) -> str: ...
    @property
    def value(self) -> Any: ...

class _LineSource:
    def __init__(self, text: str) -> None: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def __iter__(self) -> Generator[_Line]: ...
    def __nonzero__(self) -> bool: ...
    def __repr__(self) -> str: ...

class _Line(tuple):
    def __new__(cls, text: str, remainder) -> Self: ...
    def __gt__(self, other: Self) -> bool: ...
    def __lt__(self, other: Self) -> bool: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    @property
    def remainder(self): ...
    @property
    def text(self): ...

class _Fonts:
    fonts: dict[tuple[PathLike | str, float], ImageFont.FreeTypeFont] = ...
    @classmethod
    def font(cls, font_path: PathLike | str, point_size: float): ...
