from typing import Self

from pptx.dml.color import ColorFormat
from pptx.dml.fill import FillFormat
from pptx.enum.lang import MSO_LANGUAGE_ID
from pptx.enum.text import MSO_AUTO_SIZE, MSO_TEXT_UNDERLINE_TYPE, MSO_VERTICAL_ANCHOR, PP_PARAGRAPH_ALIGNMENT
from pptx.oxml.text import CT_RegularTextRun, CT_TextBody, CT_TextCharacterProperties, CT_TextParagraph
from pptx.shapes import Subshape
from pptx.types import ProvidesPart
from pptx.util import Length, lazyproperty

class TextFrame(Subshape):
    _element: CT_TextBody
    _parent: ProvidesPart

    def __init__(self, txBody: CT_TextBody, parent: ProvidesPart) -> None: ...
    def add_paragraph(self) -> _Paragraph: ...
    @property
    def auto_size(self) -> MSO_AUTO_SIZE | None: ...
    @auto_size.setter
    def auto_size(self, value: MSO_AUTO_SIZE | None) -> None: ...
    def clear(self) -> None: ...
    def fit_text(
        self,
        font_family: str = ...,
        max_size: int = ...,
        bold: bool = ...,
        italic: bool = ...,
        font_file: str | None = ...,
    ) -> None: ...
    @property
    def margin_bottom(self) -> Length: ...
    @margin_bottom.setter
    def margin_bottom(self, emu: Length) -> None: ...
    @property
    def margin_left(self) -> Length: ...
    @margin_left.setter
    def margin_left(self, emu: Length) -> None: ...
    @property
    def margin_right(self) -> Length: ...
    @margin_right.setter
    def margin_right(self, emu: Length) -> None: ...
    @property
    def margin_top(self) -> Length: ...
    @margin_top.setter
    def margin_top(self, emu: Length) -> None: ...
    @property
    def paragraphs(self) -> tuple[_Paragraph, ...]: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...
    @property
    def vertical_anchor(self) -> MSO_VERTICAL_ANCHOR | None: ...
    @vertical_anchor.setter
    def vertical_anchor(self, value: MSO_VERTICAL_ANCHOR | None) -> None: ...
    @property
    def word_wrap(self) -> bool | None: ...
    @word_wrap.setter
    def word_wrap(self, value: bool | None) -> None: ...
    def _apply_fit(self, font_family: str, font_size: int, is_bold: bool, is_italic: bool): ...
    def _best_fit_font_size(
        self, family: str, max_size: int, bold: bool, italic: bool, font_file: str | None
    ) -> int: ...
    def _set_font(self, family: str, size: int, bold: bool, italic: bool): ...

class Font:
    _element: CT_TextCharacterProperties
    def __init__(self, rPr: CT_TextCharacterProperties) -> None: ...
    @property
    def bold(self) -> bool | None: ...
    @bold.setter
    def bold(self, value: bool | None) -> None: ...
    @lazyproperty
    def color(self) -> ColorFormat: ...
    @lazyproperty
    def fill(self) -> FillFormat: ...
    @property
    def italic(self) -> bool | None: ...
    @italic.setter
    def italic(self, value: bool | None) -> None: ...
    @property
    def language_id(self) -> MSO_LANGUAGE_ID | None: ...
    @language_id.setter
    def language_id(self, value: MSO_LANGUAGE_ID | None) -> None: ...
    @property
    def name(self) -> str | None: ...
    @name.setter
    def name(self, value: str | None) -> None: ...
    @property
    def size(self) -> Length | None: ...
    @size.setter
    def size(self, emu: Length | None) -> None: ...
    @property
    def underline(self) -> bool | MSO_TEXT_UNDERLINE_TYPE | None: ...
    @underline.setter
    def underline(self, value: bool | MSO_TEXT_UNDERLINE_TYPE | None) -> None: ...

class _Hyperlink(Subshape):
    _rPr: CT_TextCharacterProperties
    def __init__(self, rPr: CT_TextCharacterProperties, parent: ProvidesPart) -> None: ...
    @property
    def address(self) -> str | None: ...
    @address.setter
    def address(self, url: str | None) -> None: ...

class _Paragraph(Subshape):
    _element: CT_TextParagraph
    _p: CT_TextParagraph
    def __init__(self, p: CT_TextParagraph, parent: ProvidesPart) -> None: ...
    def add_line_break(self) -> None: ...
    def add_run(self) -> _Run: ...
    @property
    def alignment(self) -> PP_PARAGRAPH_ALIGNMENT | None: ...
    @alignment.setter
    def alignment(self, value: PP_PARAGRAPH_ALIGNMENT | None) -> None: ...
    def clear(self) -> Self: ...
    @property
    def font(self) -> Font: ...
    @property
    def level(self) -> int: ...
    @level.setter
    def level(self, level: int) -> None: ...
    @property
    def line_spacing(self) -> int | float | Length | None: ...
    @line_spacing.setter
    def line_spacing(self, value: int | float | Length | None) -> None: ...
    @property
    def runs(self) -> tuple[_Run, ...]: ...
    @property
    def space_after(self) -> Length | None: ...
    @space_after.setter
    def space_after(self, value: Length | None) -> None: ...
    @property
    def space_before(self) -> Length | None: ...
    @space_before.setter
    def space_before(self, value: Length | None) -> None: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...

class _Run(Subshape):
    _r: CT_RegularTextRun
    def __init__(self, r: CT_RegularTextRun, parent: ProvidesPart) -> None: ...
    @property
    def font(self) -> Font: ...
    @lazyproperty
    def hyperlink(self) -> _Hyperlink: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, text: str) -> None: ...
