import datetime as dt
from datetime import datetime

from pptx.opc.package import XmlPart
from pptx.oxml.coreprops import CT_CoreProperties
from pptx.package import Package

class CorePropertiesPart(XmlPart):
    """Corresponds to part named `/docProps/core.xml`.

    Contains the core document properties for this document package.
    """

    _element: CT_CoreProperties
    @classmethod
    def default(cls, package: Package) -> CorePropertiesPart:
        """Return default new |CorePropertiesPart| instance suitable as starting point.

        This provides a base for adding core-properties to a package that doesn't yet
        have any.
        """
        ...

    @property
    def author(self) -> str: ...
    @author.setter
    def author(self, value: str) -> None: ...
    @property
    def category(self) -> str: ...
    @category.setter
    def category(self, value: str) -> None: ...
    @property
    def comments(self) -> str: ...
    @comments.setter
    def comments(self, value: str) -> None: ...
    @property
    def content_status(self) -> str: ...
    @content_status.setter
    def content_status(self, value: str) -> None: ...
    @property
    def created(self) -> datetime | None: ...
    @created.setter
    def created(self, value: dt.datetime) -> None: ...
    @property
    def identifier(self) -> str: ...
    @identifier.setter
    def identifier(self, value: str) -> None: ...
    @property
    def keywords(self) -> str: ...
    @keywords.setter
    def keywords(self, value: str) -> None: ...
    @property
    def language(self) -> str: ...
    @language.setter
    def language(self, value: str) -> None: ...
    @property
    def last_modified_by(self) -> str: ...
    @last_modified_by.setter
    def last_modified_by(self, value: str) -> None: ...
    @property
    def last_printed(self) -> datetime | None: ...
    @last_printed.setter
    def last_printed(self, value: dt.datetime) -> None: ...
    @property
    def modified(self) -> datetime | None: ...
    @modified.setter
    def modified(self, value: dt.datetime) -> None: ...
    @property
    def revision(self) -> int: ...
    @revision.setter
    def revision(self, value: int) -> None: ...
    @property
    def subject(self) -> str: ...
    @subject.setter
    def subject(self, value: str) -> None: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, value: str) -> None: ...
    @property
    def version(self) -> str: ...
    @version.setter
    def version(self, value: str) -> None: ...
