import os
import logging
from pathlib import Path


logging.basicConfig(level=logging.DEBUG,
                    format='%(levelname)s %(asctime)s %(message)s',
                    datefmt='%d-%h-%y %H:%m',
                    filename='testlog.log')


def create_python_template():
    project_name = 'replace_with_project_name'

    list_of_files = ['.github/workflows/.gitkeep',
                     f'src/{project_name}/__init__.py',
                     f'src/{project_name}/components/__init__.py',
                     f'src/{project_name}/utils/__init__.py',
                     f'src/{project_name}/utils/common.py',
                     f'src/{project_name}/config/__init__.py',
                     f'src/{project_name}/config/configuration.py',
                     f'src/{project_name}/pipeline/__init__.py',
                     f'src/{project_name}/entity/__init__.py',
                     f'src/{project_name}/constants/__init__.py',
                     'config/config.yaml',
                     '.gitignore',
                     'Dockerfile',
                     'dvc.yaml',
                     'params.yaml',
                     'README.MD',
                     'secrets.yaml',
                     'pyproject.toml',
                     'research/trials.ipynb',
                     'templates/index.html',
                     'main.py',
                     'app.py'
                     ]

    for filepath in list_of_files:
        filepath = Path(filepath)
        filedir, filename = os.path.split(filepath)

        if filedir != '':
            os.makedirs(filedir, exist_ok=True)
            logging.info(f'Created directory : {filedir} for file {filename}')

        if (not os.path.exists(filepath)) or (os.path.getsize(filepath) == 0):
            with open(filepath, 'w') as f:
                logging.info(f'Created empty file : {filename}')
        else:
            logging.info(f'{filename} already exists')
