# **<img src="https://github.com/zabbix-byte/PyPulse/blob/main/logo.png" height="48px"></img> PyPulse Alpha** 


[![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![Python Version](https://img.shields.io/badge/Python-3.8-blue)](https://www.python.org/downloads/)

<div align="center">

```plaintext
██████╗ ██╗   ██╗██████╗ ██╗   ██╗██╗     ███████╗███████╗
██╔══██╗╚██╗ ██╔╝██╔══██╗██║   ██║██║     ██╔════╝██╔════╝
██████╔╝ ╚████╔╝ ██████╔╝██║   ██║██║     ███████╗█████╗  
██╔═══╝   ╚██╔╝  ██╔═══╝ ██║   ██║██║     ╚════██║██╔══╝  
██║        ██║   ██║     ╚██████╔╝███████╗███████║███████╗
╚═╝        ╚═╝   ╚═╝      ╚═════╝ ╚══════╝╚══════╝╚══════╝
```

</div>


**PyPulse** is an open-source project that simplifies the creation of desktop applications based on Chromium, using a template-based architecture. Whether you're building a web-based desktop app, a custom browser, or need to embed web content into your Python application, PyPulse provides an easy and efficient way to get started.

**Please Note**: PyPulse is currently under active development, and some features may be incomplete or subject to change. We appreciate your interest and patience as we work to improve and enhance this project.

## ✨ Features

- 🚀 **Chromium-Based**: PyPulse harnesses the power of the Chromium web engine, ensuring your desktop applications offer a modern and robust web experience.

- 📋 **Template-Based Architecture**: PyPulse's template system is a powerful feature that empowers you to decouple the presentation layer from the business logic in your web applications. PyPulse follows the DRY (Don't Repeat Yourself) principle and provides you with the capability to craft reusable HTML templates enriched with placeholders for dynamic data using Jinja2.

- 🐍 **Python-Powered**: PyPulse is written in Python, making it accessible and customizable for Python developers. No need to learn a new language or framework.

- 📖 **Open Source**: PyPulse is licensed under the MIT License, so you can use it freely in your projects, whether they are open source or proprietary.

- 🌐 **Cross-Platform**: PyPulse supports multiple platforms, including Windows, macOS, and Linux, ensuring your app can reach a wide audience.

## 🌍 Hello Word Project Preview
<img src="https://github.com/zabbix-byte/PyPulse/blob/main/HelloWordProject.gif"></img>

[**GO TO HELLO WORD PROJECT**](https://github.com/zabbix-byte/PyPulse-HelloWord-Project)

## 🚀 Getting Started

1. **Using pip install the library**
```bash
pip install python-pulse
```

2. **Create a new Project**
```bash
pypulse-manage --create_project YourProjectName
```

3. **Create a new Application (Next update)**
```bash
At this moment you can't create a new Application automatically
```


## 📚 Documentation

For detailed instructions and more information about PyPulse, please refer to the [official documentation](https://github.com/zabbix-byte/PyPulse/wiki).

## 📜 License

PyPulse is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## 💌 Contact

If you have any questions, suggestions, or feedback, please don't hesitate to reach out to us at [zabbix@ztrunk.space](mailto:zabbix@ztrunk.space).

We hope PyPulse accelerates your desktop application development and simplifies the integration of web content into your Python projects. Happy coding! 😎🚀
