# -*- coding: utf-8 -*-
from setuptools import setup

# read the contents of your README file
from os import path

this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, 'README.md')) as f:
    long_description = f.read()

setup(
    name='python-qt-live-coding',
    version='0.4.1',
    packages=['livecoding'],
    package_dir={'': 'src'},
    url='https://github.com/machinekoder/python-qt-live-coding/',
    license='MIT',
    author='Alexander Rössler',
    author_email='alex@machinekoder.com',
    description='Live coding for Python, Qt and QML',
    long_description=long_description,
    long_description_content_type='text/markdown',
    install_requires=['six', 'qtpy'],
    extras_require={
        'dev': [
            'pytest',
            'pytest-pep8',
            'pytest-cov',
            'pytest-qt',
            'black',
            'pre-commit',
        ]
    },
    scripts=['bin/python_qt_live_coding'],
    include_package_data=True,
)
