# The RAG API
Query your documents powered by AI

## Requirements
Have the following tools installed on your computer
- Git
- Docker
## Usage
1. Start by cloning the project.  
```sh
    git clone -b java-to-python-rag-app --single-branch <repo_url>
```
2. Open the project with an IDE or a text editor
3. In the project root directory, rename the **.env.example** file to **.env** and fill in the values
    > **Note:** Make sure that the container_name of the qdrant service in the docker-compose.yaml file matches the QDRANT_HOST in the .env file
4. Open a terminal and run: 
``` sh 
    docker-compose up --build
```
5. Once the download is complete and the applicaiton has been started, go the [http://localhost:8000/docs](http://localhost:8000/docs) to use the api.

## Use the api as a module

If you want to use the api to extend your application capabilities with rag support already made, please follow these steps:
1. Clone the repository.
2. Move the module into the root directory of your project 
>**Note:** Rename the module to **ragapi**
3. Open a terminal and run the following commands 
```sh
    cd python-ragapi
    pip install -e .
```
>**Note:** When creating a new instance of **FastAPI** in your main.py file, use another variable name instead of **app** to avoid conflicts.