import os
import getpass
from dotenv import load_dotenv
from langchain_openai import AzureChatOpenAI
load_dotenv()

if "AZURE_OPENAI_API_KEY" not in os.environ:
    os.environ["AZURE_OPENAI_API_KEY"] = getpass.getpass(
        "Enter your AzureOpenAI API key: "
    )
os.environ["AZURE_OPENAI_ENDPOINT"] = "https://cgiaura-openai-trainning.openai.azure.com/"

llm = AzureChatOpenAI(
    azure_deployment = os.getenv("AZURE_OPENAI_API_DEPLOYMENT_NAME"),
    api_version = os.getenv("AZURE_OPENAI_API_VERSION"),
    temperature = os.getenv("TEMPERATURE")
)

