/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Literal;
import ida.utils.Sugar;
import ida.utils.tuples.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class PrologParser {
    private PrologParser() {
    }

    public static List<Pair<List<Literal>, List<Literal>>> parse(Reader reader, String ... ignoredPredicates) throws IOException {
        final Set ignoredPredicatesSet = Sugar.setFromCollections(Arrays.asList(ignoredPredicates));
        BufferedReader b = new BufferedReader(reader);
        ArrayList<Pair<List<Literal>, List<Literal>>> list = new ArrayList<Pair<List<Literal>, List<Literal>>>();
        String line = null;
        String unfinishedLine = null;
        while ((line = b.readLine()) != null) {
            line = line.trim();
            if (unfinishedLine != null) {
                line = unfinishedLine + line;
                unfinishedLine = null;
            }
            if (line.lastIndexOf(46) == line.length() - 1 && line.lastIndexOf(46) != 0) {
                try {
                    if (line.trim().length() <= 0 || line.indexOf("%") != -1) continue;
                    Pair<List<Literal>, List<Literal>> parsedLine = PrologParser.parseLine(line);
                    if (parsedLine.r != null) {
                        parsedLine.r = Sugar.removeNulls(Sugar.funcall((List)parsedLine.r, new Sugar.Fun<Literal, Literal>(){

                            @Override
                            public Literal apply(Literal t) {
                                if (t != null && !ignoredPredicatesSet.contains(t.predicate())) {
                                    return t;
                                }
                                return null;
                            }
                        }));
                    }
                    if (parsedLine.s != null) {
                        parsedLine.s = Sugar.removeNulls(Sugar.funcall((List)parsedLine.s, new Sugar.Fun<Literal, Literal>(){

                            @Override
                            public Literal apply(Literal t) {
                                if (t != null && !ignoredPredicatesSet.contains(t.predicate())) {
                                    return t;
                                }
                                return null;
                            }
                        }));
                    }
                    if ((parsedLine.r == null || ((List)parsedLine.r).size() <= 0) && (parsedLine.s == null || ((List)parsedLine.s).size() <= 0)) continue;
                    list.add(parsedLine);
                    continue;
                }
                catch (RuntimeException rte) {
                    System.out.println("Exception occured when parsing line: " + line);
                    throw rte;
                }
            }
            unfinishedLine = line;
        }
        return list;
    }

    public static Pair<List<Literal>, List<Literal>> parseLine(String line) {
        if (line.indexOf("%") != -1) {
            line = line.substring(0, line.indexOf("%"));
        }
        if ((line = line.trim()).lastIndexOf(46) == line.length() - 1) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.indexOf(":-") != -1) {
            String[] split = line.split(":-");
            String head = split[0];
            String tail = split[1];
            return new Pair<List<Literal>, List<Literal>>(Sugar.listFromCollections(Clause.parse(head).literals()), Sugar.listFromCollections(Clause.parse(tail).literals()));
        }
        return new Pair(Sugar.listFromCollections(Clause.parse(line).literals()), null);
    }
}

