/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Constant;
import ida.ilp.basic.Function;
import ida.ilp.basic.Literal;
import ida.ilp.basic.PrologList;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.ilp.basic.subsumption.SubsumptionEngineJ2;
import ida.utils.IntegerFunction;
import ida.utils.MutableInteger;
import ida.utils.StringUtils;
import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Matching {
    public static final int THETA_SUBSUMPTION = 1;
    public static final int OI_SUBSUMPTION = 2;
    public static final int SELECTIVE_OI_SUBSUMPTION = 3;
    private List<SubsumptionEngineJ2.ClauseE> positiveExamples = new ArrayList<SubsumptionEngineJ2.ClauseE>();
    private List<SubsumptionEngineJ2.ClauseE> negativeExamples = new ArrayList<SubsumptionEngineJ2.ClauseE>();
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int UNDECIDED = 3;
    private int resumerVersion = 2;
    private SubsumptionEngineJ2 engine;
    private boolean adaptPropagationStrength = false;
    private boolean constants = true;
    private boolean learnVariableOrdering = true;
    private Random random = new Random();

    public Matching() {
        this.engine = new SubsumptionEngineJ2();
        this.engine.setRestartSequence(new IntegerFunction.Exponential(50, 2, 500));
    }

    public Matching(List<Clause> positiveExamples, List<Clause> negativeExamples) {
        this(new SubsumptionEngineJ2(), positiveExamples, negativeExamples);
    }

    public Matching(SubsumptionEngineJ2 engine, List<Clause> positiveExamples, List<Clause> negativeExamples) {
        this.engine = engine;
        this.engine.setRestartSequence(new IntegerFunction.Exponential(50, 2, 500));
        for (Clause e : positiveExamples) {
            if (this.constants) {
                e = this.preprocessExample(e);
            }
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            this.positiveExamples.add(new SubsumptionEngineJ2.ClauseE(subsumptionEngineJ2, e));
        }
        for (Clause e : negativeExamples) {
            if (this.constants) {
                e = this.preprocessExample(e);
            }
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            this.negativeExamples.add(new SubsumptionEngineJ2.ClauseE(subsumptionEngineJ2, e));
        }
    }

    public void setRestartSequence(IntegerFunction f) {
        this.engine.setRestartSequence(f);
    }

    public int[] evaluatePositiveExamples(Clause hypothesis, boolean[] undecided) {
        return this.evaluateExamples(hypothesis, this.positiveExamples, undecided);
    }

    public int[] evaluateNegativeExamples(Clause hypothesis, boolean[] undecided) {
        return this.evaluateExamples(hypothesis, this.negativeExamples, undecided);
    }

    private int[] evaluateExamples(Clause hypothesis, List<SubsumptionEngineJ2.ClauseE> examples, boolean[] undecided) {
        int[] retVal = new int[undecided.length];
        undecided = VectorUtils.copyArray(undecided);
        Arrays.fill(retVal, 3);
        for (Clause component : hypothesis.connectedComponents()) {
            int[] result = this.evaluateExamplesAgainstOneComponent(component, examples, undecided);
            for (int i = 0; i < result.length; ++i) {
                if (undecided[i] && result[i] == 2) {
                    retVal[i] = 2;
                    undecided[i] = false;
                    continue;
                }
                if (!undecided[i] || result[i] != 1) continue;
                retVal[i] = 1;
            }
        }
        return retVal;
    }

    private int[] evaluateExamplesAgainstOneComponent(Clause hypothesis, List<SubsumptionEngineJ2.ClauseE> examples, boolean[] undecided) {
        double t2;
        if (this.constants) {
            hypothesis = this.preprocessHypothesis(hypothesis);
        }
        SubsumptionEngineJ2.ClauseStructure c = null;
        if (this.resumerVersion < 3) {
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            c = new SubsumptionEngineJ2.ClauseC(subsumptionEngineJ2, hypothesis);
        } else {
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            c = new SubsumptionEngineJ2.DecomposedClauseC(subsumptionEngineJ2, hypothesis);
        }
        int[] result = new int[undecided.length];
        int j = 0;
        this.engine.setFirstVariableOrder(null);
        boolean UP = false;
        boolean DOWN = true;
        int shift = this.random.nextInt(2);
        boolean[] shiftOrNot = VectorUtils.randomBooleanVector(undecided.length, this.random);
        long time1 = 0L;
        int maxRestart = 0;
        if (this.adaptPropagationStrength) {
            if (shift == 0) {
                this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() + 1);
            } else if (shift == 1) {
                this.engine.setArcConsistencyFrom(Math.max(1, this.engine.getArcConsistencyFrom() - 1));
            }
        }
        long m1 = System.currentTimeMillis();
        for (int i = 0; i < undecided.length; ++i) {
            if (!undecided[i] || !shiftOrNot[i]) continue;
            if (j > 0 && this.learnVariableOrdering) {
                this.engine.setFirstVariableOrder(this.engine.getLastVariableOrder());
            }
            Boolean succ = this.engine.solveWithResumer(c, examples.get(i), this.resumerVersion);
            maxRestart = Math.max(this.engine.getNoOfRestarts(), maxRestart);
            if (!this.engine.solvedWithoutSearch()) {
                ++j;
            }
            result[i] = succ == null ? 3 : (succ != false ? 1 : 2);
        }
        long m2 = System.currentTimeMillis();
        time1 = m2 - m1;
        if (this.adaptPropagationStrength) {
            if (shift == 0) {
                this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() - 1);
            } else {
                this.engine.setArcConsistencyFrom(Math.max(0, this.engine.getArcConsistencyFrom() + 1));
            }
        }
        m1 = System.currentTimeMillis();
        for (int i = 0; i < undecided.length; ++i) {
            if (!undecided[i] || shiftOrNot[i]) continue;
            if (j > 0 && this.learnVariableOrdering) {
                this.engine.setFirstVariableOrder(this.engine.getLastVariableOrder());
            }
            Boolean succ = this.engine.solveWithResumer(c, examples.get(i), this.resumerVersion);
            maxRestart = Math.max(this.engine.getNoOfRestarts(), maxRestart);
            if (!this.engine.solvedWithoutSearch()) {
                ++j;
            }
            result[i] = succ == null ? 3 : (succ != false ? 1 : 2);
        }
        m2 = System.currentTimeMillis();
        long time2 = m2 - m1;
        double t1 = (double)time1 / (double)VectorUtils.occurences(VectorUtils.and(undecided, shiftOrNot), true);
        if (t1 < (t2 = (double)time2 / (double)VectorUtils.occurences(VectorUtils.and(undecided, VectorUtils.not(shiftOrNot)), true)) && this.adaptPropagationStrength) {
            if (shift == 0) {
                if (maxRestart > this.engine.getArcConsistencyFrom() && this.engine.getArcConsistencyFrom() > 1) {
                    this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() + 1);
                }
            } else if (shift == 1) {
                this.engine.setArcConsistencyFrom(Math.max(1, this.engine.getArcConsistencyFrom() - 1));
            }
        }
        return result;
    }

    public void setSubsumptionMode(int mode) {
        this.engine.setSubsumptionMode(mode);
    }

    public void setForwardCheckingStartsIn(int restart) {
        this.engine.setForwardCheckingFrom(restart);
    }

    public void setArcConsistencyStartsIn(int restart) {
        this.engine.setArcConsistencyFrom(restart);
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public void setAdaptPropagationStrength(boolean adaptPropagationStrength) {
        this.adaptPropagationStrength = adaptPropagationStrength;
    }

    public SubsumptionEngineJ2 getEngine() {
        return this.engine;
    }

    public SubsumptionEngineJ2.ClauseC createClauseC(Clause c) {
        return this.engine.createCluaseC(this.preprocessHypothesis(c));
    }

    public SubsumptionEngineJ2.ClauseE createClauseE(Clause e) {
        return this.engine.createClauseE(this.preprocessExample(e));
    }

    public Boolean subsumption(SubsumptionEngineJ2.ClauseC c, SubsumptionEngineJ2.ClauseE e) {
        return this.engine.solveWithResumer(c, e, this.resumerVersion);
    }

    public Boolean subsumption(Clause c, Clause e) {
        e = this.preprocessExample(e);
        for (Clause component : c.connectedComponents()) {
            if (this.constants) {
                component = this.preprocessHypothesis(component);
            }
            if (this.engine.solveWithResumer(component, e, this.resumerVersion).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Pair<Term[], List<Term[]>> allSubstitutions_P(Clause c, int exampleIndex) {
        return this.allSubstitutions(c, exampleIndex, true);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions_N(Clause c, int exampleIndex) {
        return this.allSubstitutions(c, exampleIndex, false);
    }

    private Pair<Term[], List<Term[]>> allSubstitutions(Clause c, int exampleIndex, boolean positive) {
        if (this.constants) {
            c = this.preprocessHypothesis(c);
        }
        SubsumptionEngineJ2.ClauseC cc = this.createClauseC(c);
        Pair<Term[], List<Term[]>> allSolutions = null;
        allSolutions = positive ? this.engine.allSolutions(cc, this.positiveExamples.get(exampleIndex)) : this.engine.allSolutions(cc, this.negativeExamples.get(exampleIndex));
        if (!this.constants) {
            return allSolutions;
        }
        boolean[] actuallyConstants = new boolean[((Term[])allSolutions.r).length];
        int index = 0;
        for (Term t : (Term[])allSolutions.r) {
            for (Literal l : c.getLiteralsByTerm(t)) {
                if (l.predicate().indexOf("[#]") != -1) {
                    actuallyConstants[index] = true;
                    break;
                }
                actuallyConstants[index] = false;
            }
            ++index;
        }
        Term[] newTemplate = new Term[VectorUtils.occurences(actuallyConstants, false)];
        int j = 0;
        for (int i = 0; i < ((Term[])allSolutions.r).length; ++i) {
            if (actuallyConstants[i]) continue;
            newTemplate[j] = ((Term[])allSolutions.r)[i];
            ++j;
        }
        ArrayList<Term[]> newSolutions = new ArrayList<Term[]>();
        for (Term[] solution : (List)allSolutions.s) {
            int k = 0;
            Term[] newSolution = new Term[newTemplate.length];
            for (int i = 0; i < solution.length; ++i) {
                if (actuallyConstants[i]) continue;
                newSolution[k] = solution[i];
                ++k;
            }
            newSolutions.add(newSolution);
        }
        return new Pair<Term[], List<Term[]>>(newTemplate, newSolutions);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, Clause e, int maxCount) {
        if (this.constants) {
            c = this.preprocessHypothesis(c);
            e = this.preprocessExample(e);
        }
        Pair<Term[], List<Term[]>> allSolutions = this.engine.allSolutions(c, e, maxCount);
        if (!this.constants) {
            return allSolutions;
        }
        boolean[] actuallyConstants = new boolean[((Term[])allSolutions.r).length];
        int index = 0;
        for (Term t : (Term[])allSolutions.r) {
            for (Literal l : c.getLiteralsByTerm(t)) {
                if (l.predicate().indexOf("[#]") != -1) {
                    actuallyConstants[index] = true;
                    break;
                }
                actuallyConstants[index] = false;
            }
            ++index;
        }
        Term[] newTemplate = new Term[VectorUtils.occurences(actuallyConstants, false)];
        int j = 0;
        for (int i = 0; i < ((Term[])allSolutions.r).length; ++i) {
            if (actuallyConstants[i]) continue;
            newTemplate[j] = ((Term[])allSolutions.r)[i];
            ++j;
        }
        ArrayList<Term[]> newSolutions = new ArrayList<Term[]>();
        for (Term[] solution : (List)allSolutions.s) {
            int k = 0;
            Term[] newSolution = new Term[newTemplate.length];
            for (int i = 0; i < solution.length; ++i) {
                if (actuallyConstants[i]) continue;
                newSolution[k] = solution[i];
                ++k;
            }
            newSolutions.add(newSolution);
        }
        return new Pair<Term[], List<Term[]>>(newTemplate, newSolutions);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, Clause e) {
        return this.allSubstitutions(c, e, Integer.MAX_VALUE);
    }

    private Clause preprocessHypothesis(Clause e) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        Set<Term> usedTerms = Sugar.setFromCollections(e.terms());
        HashMap<Term, Variable> selectedVariables = new HashMap<Term, Variable>();
        MutableInteger varIndex = new MutableInteger(0);
        for (Literal l : e.literals()) {
            Literal copy = l.copy();
            for (int i = 0; i < l.arity(); ++i) {
                if (l.get(i) instanceof Constant) {
                    Literal constLit = new Literal(l.get(i).name() + "[#]", 1);
                    Variable variabilizedConstant = this.variabilize(l.get(i), varIndex, usedTerms, selectedVariables);
                    constLit.set((Term)variabilizedConstant, 0);
                    literals.add(constLit);
                    copy.set((Term)variabilizedConstant, i);
                    continue;
                }
                if (!(l.get(i) instanceof Function) && !(l.get(i) instanceof PrologList)) continue;
            }
            literals.add(copy);
        }
        return new Clause(literals);
    }

    private Variable variabilize(Term a, MutableInteger varIndex, Set<Term> terms, Map<Term, Variable> selectedVariables) {
        Variable variabilizedConstant = Variable.construct(StringUtils.capitalize(a.name()));
        if (terms.contains(variabilizedConstant)) {
            if (selectedVariables.containsKey(a)) {
                return selectedVariables.get(a);
            }
            do {
                varIndex.increment();
            } while (terms.contains(Variable.construct("V" + varIndex.value())));
            Variable newVariable = Variable.construct("V" + varIndex.value());
            terms.add(newVariable);
            selectedVariables.put(a, newVariable);
            return newVariable;
        }
        return variabilizedConstant;
    }

    private Clause preprocessExample(Clause e) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        for (Literal l : e.literals()) {
            Literal copy = l.copy();
            for (int i = 0; i < l.arity(); ++i) {
                if (l.get(i) instanceof Constant) {
                    Literal constLit = new Literal(l.get(i).name() + "[#]", 1);
                    constLit.set(l.get(i), 0);
                    literals.add(constLit);
                    copy.set(l.get(i), i);
                    continue;
                }
                if (!(l.get(i) instanceof Function) && !(l.get(i) instanceof PrologList)) continue;
            }
            literals.add(copy);
        }
        return new Clause(literals);
    }

    public Clause reduction(Clause c) {
        if (this.constants) {
            c = this.preprocessHypothesis(c);
        }
        Clause reduction = this.engine.reduce(c);
        if (!this.constants) {
            return reduction;
        }
        HashMap<Term, Constant> toBeChanged = new HashMap<Term, Constant>();
        int index = 0;
        for (Term t : reduction.terms()) {
            for (Literal l : c.getLiteralsByTerm(t)) {
                if (l.predicate().indexOf("[#]") == -1) continue;
                toBeChanged.put(l.get(0), Constant.construct(l.predicate().substring(0, l.predicate().indexOf("[#]"))));
                break;
            }
            ++index;
        }
        ArrayList<Literal> newLiterals = new ArrayList<Literal>();
        for (Literal l : reduction.literals()) {
            Literal copy = l.copy();
            for (int i = 0; i < l.arity(); ++i) {
                if (!toBeChanged.containsKey(l.get(i))) continue;
                copy.set((Term)toBeChanged.get(l.get(i)), i);
            }
            if (copy.predicate().indexOf("[#]") != -1) continue;
            newLiterals.add(copy);
        }
        reduction = new Clause(newLiterals);
        return reduction;
    }

    public void setResumerVersion(int version) {
        this.resumerVersion = version;
    }

    public void setLearnVariableOrdering(boolean learn) {
        this.learnVariableOrdering = learn;
    }

    public void setRandomSeed(long seed) {
        this.random = new Random(seed);
        this.engine.setRandomSeed(seed);
    }
}

