/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import proper.database.Column;
import proper.database.Connector;
import proper.database.ExecutorObject;

public class Modifier
extends ExecutorObject {
    public Modifier(Connector conn) {
        super(conn);
    }

    public boolean renameTable(String oldName, String newName) {
        String sql = "ALTER TABLE " + oldName + " RENAME TO " + newName;
        boolean result = this.exec.update(sql);
        if (this.getVerbose()) {
            this.println("Rename table: " + sql + " = " + result);
        }
        return result;
    }

    public boolean renameColumn(String table, String oldName, String newName) {
        boolean result = true;
        String sql = "";
        String colType = "";
        int nullable = 1;
        try {
            ResultSet rs = this.getConnector().getConnection().getMetaData().getColumns(null, null, table, oldName);
            if (rs == null || !rs.first()) {
                result = false;
            }
            if (result) {
                colType = Column.typeToString(rs.getInt("DATA_TYPE"));
                if (colType == null) {
                    throw new Exception("Cannot convert SQL-Type " + rs.getInt("DATA_TYPE") + "!");
                }
                nullable = rs.getInt("NULLABLE");
            }
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        if (result) {
            sql = "ALTER TABLE " + table + " RENAME COLUMN " + oldName + " TO " + newName;
            if (nullable == 0) {
                sql = String.valueOf(sql) + " NOT NULL";
            }
            if (!(result = this.exec.update(sql))) {
                sql = "ALTER TABLE " + table + " CHANGE " + oldName + " " + newName + " " + colType;
                if (nullable == 0) {
                    sql = String.valueOf(sql) + " NOT NULL";
                }
                result = this.exec.update(sql);
            }
        }
        if (this.getVerbose()) {
            this.println("Rename column (" + table + "." + oldName + " -> " + newName + ": " + sql + " = " + result);
        }
        return result;
    }

    public boolean deleteColumn(String table, String name) {
        String sql = "ALTER TABLE " + table + " DROP COLUMN " + name;
        boolean result = this.exec.update(sql);
        if (!result) {
            this.println("ERROR: " + this.exec.getLastStatement());
            this.println(this.exec.getLastException());
        }
        if (this.getVerbose()) {
            this.println("delete column " + table + "." + name + " = " + result);
        }
        return result;
    }
}

