/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.io.FileWriter;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.database.Reader;
import weka.core.Instances;
import weka.core.Utils;

public class Writer
extends ConnectorObject {
    public static final boolean USE_TOSTRING = false;
    private Instances instances;
    private Reader reader;
    private String filename;

    public Writer(Connector conn) {
        this(conn, "", "");
    }

    public Writer(Connector conn, String table, String field) {
        super(conn);
        this.reader = new Reader(conn, table, field);
        this.filename = "";
    }

    public void setRelationName(String relation) {
        this.reader.setRelationName(relation);
    }

    public String getRelationName() {
        return this.reader.getRelationName();
    }

    public void setTable(String table) {
        this.reader.setTable(table);
        this.instances = null;
    }

    public String getTable() {
        return this.reader.getTable();
    }

    public void setField(String field) {
        this.reader.setField(field);
        this.instances = null;
    }

    public String getField() {
        return this.reader.getField();
    }

    public void setOrderBy(String orderBy) {
        this.reader.setOrderBy(orderBy);
        this.instances = null;
    }

    public String getOrderBy() {
        return this.reader.getOrderBy();
    }

    public void setSort(boolean sort) {
        this.reader.setSort(sort);
        this.instances = null;
    }

    public boolean getSort() {
        return this.reader.getSort();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFieldList(String fields) {
        this.reader.setFieldList(fields);
    }

    public String getFieldList() {
        return this.reader.getFieldList();
    }

    public void setNominalList(String fields) {
        this.reader.setNominalList(fields);
    }

    public String getNominalList() {
        return this.reader.getNominalList();
    }

    public void setNoNullsList(String fields) {
        this.reader.setNoNullsList(fields);
    }

    public String getNoNullsList() {
        return this.reader.getNoNullsList();
    }

    public void setPercentage(double percentage) {
        this.reader.setPercentage(percentage);
    }

    public double getPercentage() {
        return this.reader.getPercentage();
    }

    public void setInstances(Instances instances) {
        this.instances = instances;
    }

    public Instances getInstances() {
        return this.instances;
    }

    public void write() {
        if (this.instances == null) {
            this.reader.setVerbose(this.getVerbose());
            this.reader.read();
            this.instances = this.reader.getInstances();
        }
        this.write(this.instances);
    }

    public void write(Instances instances) {
        if (!this.getFilename().equals("")) {
            try {
                FileWriter writer = new FileWriter(this.getFilename());
                StringBuffer line = new StringBuffer();
                line.append("@relation ").append(Utils.quote((String)instances.relationName())).append("\n\n");
                int i = 0;
                while (i < instances.numAttributes()) {
                    line.append(instances.attribute(i)).append("\n");
                    ++i;
                }
                writer.write(line.toString());
                line = new StringBuffer();
                line.append("\n").append("@data\n");
                i = 0;
                while (i < instances.numInstances()) {
                    line.append(instances.instance(i));
                    if (i < instances.numInstances() - 1) {
                        line.append('\n');
                    }
                    if (i % 100 == 0 || i == instances.numInstances() - 1) {
                        writer.write(line.toString());
                        line = new StringBuffer();
                    }
                    ++i;
                }
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                this.println(e);
            }
        } else {
            this.println("No filename provided - nothing written!");
        }
    }
}

